/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.application;

import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.stratos.messaging.domain.application.ApplicationStatus;
import org.apache.stratos.messaging.domain.application.ParentComponent;
import org.apache.stratos.messaging.domain.instance.ApplicationInstance;
import org.apache.stratos.messaging.domain.instance.Instance;

public class Application
extends ParentComponent<ApplicationInstance> {
    private static final long serialVersionUID = -5092959597171649688L;
    private String id;
    private String name;
    private String description;
    private String key;
    private int tenantId;
    private String tenantDomain;
    private String tenantAdminUserName;
    private String applicationPolicyId;

    public Application(String id) {
        this.id = id;
        this.key = RandomStringUtils.randomAlphanumeric((int)16);
        this.setInstanceIdToInstanceContextMap(new HashMap());
    }

    @Override
    public String getUniqueIdentifier() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public String getTenantAdminUserName() {
        return this.tenantAdminUserName;
    }

    public void setTenantAdminUserName(String tenantAdminUserName) {
        this.tenantAdminUserName = tenantAdminUserName;
    }

    public boolean isStateTransitionValid(ApplicationStatus newState, String applicationInstancetId) {
        return ((ApplicationInstance)this.getInstanceIdToInstanceContextMap().get(applicationInstancetId)).isStateTransitionValid(newState);
    }

    public Stack<ApplicationStatus> getTransitionedStates(String applicationInstancetId) {
        return ((ApplicationInstance)this.getInstanceIdToInstanceContextMap().get(applicationInstancetId)).getTransitionedStates();
    }

    public ApplicationStatus getStatus() {
        if (this.getInstanceIdToInstanceContextMap() != null && this.getInstanceIdToInstanceContextMap().size() > 0) {
            boolean applicationActive = true;
            for (ApplicationInstance applicationInstance : this.getInstanceIdToInstanceContextMap().values()) {
                if (applicationInstance.getStatus() == ApplicationStatus.Active) continue;
                applicationActive = false;
            }
            if (applicationActive) {
                return ApplicationStatus.Active;
            }
        }
        return ApplicationStatus.Inactive;
    }

    public ApplicationStatus getStatus(String applicationInstanceId) {
        return ((ApplicationInstance)this.getInstanceIdToInstanceContextMap().get(applicationInstanceId)).getStatus();
    }

    public boolean setStatus(ApplicationStatus newState, String applicationInstanceId) {
        return ((ApplicationInstance)this.getInstanceIdToInstanceContextMap().get(applicationInstanceId)).setStatus(newState);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Application)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Application that = (Application)other;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Instance getInstanceByNetworkPartitionId(String networkPartitionId) {
        if (this.getInstanceIdToInstanceContextMap().isEmpty()) {
            return null;
        }
        for (Instance instance : this.getInstanceIdToInstanceContextMap().values()) {
            if (!instance.getNetworkPartitionId().equals(networkPartitionId)) continue;
            return instance;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getApplicationPolicyId() {
        return this.applicationPolicyId;
    }

    public void setApplicationPolicyId(String applicationPolicyId) {
        this.applicationPolicyId = applicationPolicyId;
    }
}

