/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.threading;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StratosThreadPool {
    private static final Log log = LogFactory.getLog(StratosThreadPool.class);
    private static Map<String, ExecutorService> executorServiceMap = new ConcurrentHashMap<String, ExecutorService>();
    private static Map<String, ScheduledExecutorService> scheduledServiceMap = new ConcurrentHashMap<String, ScheduledExecutorService>();
    private static Object executorServiceMapLock = new Object();
    private static Object scheduledServiceMapLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getExecutorService(String identifier, int threadPoolSize) {
        ExecutorService executorService = executorServiceMap.get(identifier);
        if (executorService == null) {
            Object object = executorServiceMapLock;
            synchronized (object) {
                if (executorService == null) {
                    executorService = Executors.newFixedThreadPool(threadPoolSize);
                    executorServiceMap.put(identifier, executorService);
                    log.info((Object)String.format("Thread pool created: [type] Executor Service [id] %s [size] %d", identifier, threadPoolSize));
                }
            }
        }
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledExecutorService getScheduledExecutorService(String identifier, int threadPoolSize) {
        ScheduledExecutorService scheduledExecutorService = scheduledServiceMap.get(identifier);
        if (scheduledExecutorService == null) {
            Object object = scheduledServiceMapLock;
            synchronized (object) {
                if (scheduledExecutorService == null) {
                    scheduledExecutorService = Executors.newScheduledThreadPool(threadPoolSize);
                    scheduledServiceMap.put(identifier, scheduledExecutorService);
                    log.info((Object)String.format("Thread pool created: [type] Scheduled Executor Service [id] %s [size] %d", identifier, threadPoolSize));
                }
            }
        }
        return scheduledExecutorService;
    }
}

