/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import org.wso2.andes.transport.Acquired;
import org.wso2.andes.transport.ConnectionClose;
import org.wso2.andes.transport.ConnectionCloseOk;
import org.wso2.andes.transport.ConnectionHeartbeat;
import org.wso2.andes.transport.ConnectionOpen;
import org.wso2.andes.transport.ConnectionOpenOk;
import org.wso2.andes.transport.ConnectionRedirect;
import org.wso2.andes.transport.ConnectionSecure;
import org.wso2.andes.transport.ConnectionSecureOk;
import org.wso2.andes.transport.ConnectionStart;
import org.wso2.andes.transport.ConnectionStartOk;
import org.wso2.andes.transport.ConnectionTune;
import org.wso2.andes.transport.ConnectionTuneOk;
import org.wso2.andes.transport.DeliveryProperties;
import org.wso2.andes.transport.DtxCommit;
import org.wso2.andes.transport.DtxEnd;
import org.wso2.andes.transport.DtxForget;
import org.wso2.andes.transport.DtxGetTimeout;
import org.wso2.andes.transport.DtxPrepare;
import org.wso2.andes.transport.DtxRecover;
import org.wso2.andes.transport.DtxRollback;
import org.wso2.andes.transport.DtxSelect;
import org.wso2.andes.transport.DtxSetTimeout;
import org.wso2.andes.transport.DtxStart;
import org.wso2.andes.transport.ExchangeBind;
import org.wso2.andes.transport.ExchangeBound;
import org.wso2.andes.transport.ExchangeBoundResult;
import org.wso2.andes.transport.ExchangeDeclare;
import org.wso2.andes.transport.ExchangeDelete;
import org.wso2.andes.transport.ExchangeQuery;
import org.wso2.andes.transport.ExchangeQueryResult;
import org.wso2.andes.transport.ExchangeUnbind;
import org.wso2.andes.transport.ExecutionException;
import org.wso2.andes.transport.ExecutionResult;
import org.wso2.andes.transport.ExecutionSync;
import org.wso2.andes.transport.FragmentProperties;
import org.wso2.andes.transport.GetTimeoutResult;
import org.wso2.andes.transport.MessageAccept;
import org.wso2.andes.transport.MessageAcquire;
import org.wso2.andes.transport.MessageCancel;
import org.wso2.andes.transport.MessageFlow;
import org.wso2.andes.transport.MessageFlush;
import org.wso2.andes.transport.MessageProperties;
import org.wso2.andes.transport.MessageReject;
import org.wso2.andes.transport.MessageRelease;
import org.wso2.andes.transport.MessageResume;
import org.wso2.andes.transport.MessageResumeResult;
import org.wso2.andes.transport.MessageSetFlowMode;
import org.wso2.andes.transport.MessageStop;
import org.wso2.andes.transport.MessageSubscribe;
import org.wso2.andes.transport.MessageTransfer;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.QueueDeclare;
import org.wso2.andes.transport.QueueDelete;
import org.wso2.andes.transport.QueuePurge;
import org.wso2.andes.transport.QueueQuery;
import org.wso2.andes.transport.QueueQueryResult;
import org.wso2.andes.transport.RecoverResult;
import org.wso2.andes.transport.ReplyTo;
import org.wso2.andes.transport.SessionAttach;
import org.wso2.andes.transport.SessionAttached;
import org.wso2.andes.transport.SessionCommandFragment;
import org.wso2.andes.transport.SessionCommandPoint;
import org.wso2.andes.transport.SessionCompleted;
import org.wso2.andes.transport.SessionConfirmed;
import org.wso2.andes.transport.SessionDetach;
import org.wso2.andes.transport.SessionDetached;
import org.wso2.andes.transport.SessionExpected;
import org.wso2.andes.transport.SessionFlush;
import org.wso2.andes.transport.SessionGap;
import org.wso2.andes.transport.SessionHeader;
import org.wso2.andes.transport.SessionKnownCompleted;
import org.wso2.andes.transport.SessionRequestTimeout;
import org.wso2.andes.transport.SessionTimeout;
import org.wso2.andes.transport.Struct;
import org.wso2.andes.transport.TxCommit;
import org.wso2.andes.transport.TxRollback;
import org.wso2.andes.transport.TxSelect;
import org.wso2.andes.transport.XaResult;
import org.wso2.andes.transport.Xid;

class StructFactory {
    StructFactory() {
    }

    public static Struct create(int type) {
        switch (type) {
            case -1: {
                return new SessionHeader();
            }
            case -2: {
                return new SessionCommandFragment();
            }
            case 1025: {
                return new DeliveryProperties();
            }
            case 1026: {
                return new FragmentProperties();
            }
            case -3: {
                return new ReplyTo();
            }
            case 1027: {
                return new MessageProperties();
            }
            case 1537: {
                return new XaResult();
            }
            case 1540: {
                return new Xid();
            }
            case 1028: {
                return new Acquired();
            }
            case 1029: {
                return new MessageResumeResult();
            }
            case 1538: {
                return new GetTimeoutResult();
            }
            case 1539: {
                return new RecoverResult();
            }
            case 1793: {
                return new ExchangeQueryResult();
            }
            case 1794: {
                return new ExchangeBoundResult();
            }
            case 2049: {
                return new QueueQueryResult();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static Struct createInstruction(int type) {
        switch (type) {
            case 257: {
                return new ConnectionStart();
            }
            case 258: {
                return new ConnectionStartOk();
            }
            case 259: {
                return new ConnectionSecure();
            }
            case 260: {
                return new ConnectionSecureOk();
            }
            case 261: {
                return new ConnectionTune();
            }
            case 262: {
                return new ConnectionTuneOk();
            }
            case 263: {
                return new ConnectionOpen();
            }
            case 264: {
                return new ConnectionOpenOk();
            }
            case 265: {
                return new ConnectionRedirect();
            }
            case 266: {
                return new ConnectionHeartbeat(new Option[0]);
            }
            case 267: {
                return new ConnectionClose();
            }
            case 268: {
                return new ConnectionCloseOk(new Option[0]);
            }
            case 513: {
                return new SessionAttach();
            }
            case 514: {
                return new SessionAttached();
            }
            case 515: {
                return new SessionDetach();
            }
            case 516: {
                return new SessionDetached();
            }
            case 517: {
                return new SessionRequestTimeout();
            }
            case 518: {
                return new SessionTimeout();
            }
            case 519: {
                return new SessionCommandPoint();
            }
            case 520: {
                return new SessionExpected();
            }
            case 521: {
                return new SessionConfirmed();
            }
            case 522: {
                return new SessionCompleted();
            }
            case 523: {
                return new SessionKnownCompleted();
            }
            case 524: {
                return new SessionFlush();
            }
            case 525: {
                return new SessionGap();
            }
            case 769: {
                return new ExecutionSync(new Option[0]);
            }
            case 770: {
                return new ExecutionResult();
            }
            case 771: {
                return new ExecutionException();
            }
            case 1025: {
                return new MessageTransfer();
            }
            case 1026: {
                return new MessageAccept();
            }
            case 1027: {
                return new MessageReject();
            }
            case 1028: {
                return new MessageRelease();
            }
            case 1029: {
                return new MessageAcquire();
            }
            case 1030: {
                return new MessageResume();
            }
            case 1031: {
                return new MessageSubscribe();
            }
            case 1032: {
                return new MessageCancel();
            }
            case 1033: {
                return new MessageSetFlowMode();
            }
            case 1034: {
                return new MessageFlow();
            }
            case 1035: {
                return new MessageFlush();
            }
            case 1036: {
                return new MessageStop();
            }
            case 1281: {
                return new TxSelect(new Option[0]);
            }
            case 1282: {
                return new TxCommit(new Option[0]);
            }
            case 1283: {
                return new TxRollback(new Option[0]);
            }
            case 1537: {
                return new DtxSelect(new Option[0]);
            }
            case 1538: {
                return new DtxStart();
            }
            case 1539: {
                return new DtxEnd();
            }
            case 1540: {
                return new DtxCommit();
            }
            case 1541: {
                return new DtxForget();
            }
            case 1542: {
                return new DtxGetTimeout();
            }
            case 1543: {
                return new DtxPrepare();
            }
            case 1544: {
                return new DtxRecover(new Option[0]);
            }
            case 1545: {
                return new DtxRollback();
            }
            case 1546: {
                return new DtxSetTimeout();
            }
            case 1793: {
                return new ExchangeDeclare();
            }
            case 1794: {
                return new ExchangeDelete();
            }
            case 1795: {
                return new ExchangeQuery();
            }
            case 1796: {
                return new ExchangeBind();
            }
            case 1797: {
                return new ExchangeUnbind();
            }
            case 1798: {
                return new ExchangeBound();
            }
            case 2049: {
                return new QueueDeclare();
            }
            case 2050: {
                return new QueueDelete();
            }
            case 2051: {
                return new QueuePurge();
            }
            case 2052: {
                return new QueueQuery();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }
}

