/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.AccessRequestBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class AccessRequestBodyImpl
extends AMQMethodBody_8_0
implements AccessRequestBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new AccessRequestBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 30;
    public static final int METHOD_ID = 10;
    private final AMQShortString _realm;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public AccessRequestBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._realm = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public AccessRequestBodyImpl(AMQShortString realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
        this._realm = realm;
        byte bitfield0 = 0;
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (active) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (write) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (read) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 30;
    }

    public int getMethod() {
        return 10;
    }

    public final AMQShortString getRealm() {
        return this._realm;
    }

    public final boolean getExclusive() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getPassive() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getActive() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getWrite() {
        return (this._bitfield0 & 8) != 0;
    }

    public final boolean getRead() {
        return (this._bitfield0 & 0x10) != 0;
    }

    protected int getBodySize() {
        int size = 1;
        return size += this.getSizeOf(this._realm);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._realm);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchAccessRequest(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[AccessRequestBodyImpl: ");
        buf.append("realm=");
        buf.append(this.getRealm());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("active=");
        buf.append(this.getActive());
        buf.append(", ");
        buf.append("write=");
        buf.append(this.getWrite());
        buf.append(", ");
        buf.append("read=");
        buf.append(this.getRead());
        buf.append("]");
        return buf.toString();
    }
}

