/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.definition.IdentityKeyStoreInformation;
import org.wso2.securevault.definition.KeyStoreInformationFactory;
import org.wso2.securevault.definition.TrustKeyStoreInformation;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.TrustKeyStoreWrapper;
import org.wso2.securevault.secret.SecretRepository;
import org.wso2.securevault.secret.SecretRepositoryProvider;

public class SecretManager {
    private static Log log = LogFactory.getLog(SecretManager.class);
    private static final SecretManager SECRET_MANAGER = new SecretManager();
    private static final String PROP_DEFAULT_CONF_LOCATION = "secret-manager.properties";
    private static final String PROP_SECRET_MANAGER_CONF = "secret.manager.conf";
    private static final String PROP_SECRET_REPOSITORIES = "secretRepositories";
    private static final String PROP_PROVIDER = "provider";
    private static final String DOT = ".";
    private SecretRepository parentRepository;
    private boolean initialized = false;
    private String globalSecretProvider = null;
    private static final String PROP_SECRET_PROVIDER = "carbon.secretProvider";

    public static SecretManager getInstance() {
        return SECRET_MANAGER;
    }

    private SecretManager() {
    }

    public void init(Properties properties) {
        String repositoriesString;
        if (this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug("Secret Manager already has been started.");
            }
            return;
        }
        if (properties == null) {
            if (log.isDebugEnabled()) {
                log.debug("KeyStore configuration properties cannot be found");
            }
            return;
        }
        String configurationFile = MiscellaneousUtil.getProperty(properties, PROP_SECRET_MANAGER_CONF, PROP_DEFAULT_CONF_LOCATION);
        Properties configurationProperties = MiscellaneousUtil.loadProperties(configurationFile);
        if (configurationProperties == null || configurationProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Configuration properties can not be loaded form : " + configurationFile + " Will use synapse properties");
            }
            configurationProperties = properties;
        }
        this.globalSecretProvider = MiscellaneousUtil.getProperty(configurationProperties, PROP_SECRET_PROVIDER, null);
        if ((this.globalSecretProvider == null || "".equals(this.globalSecretProvider)) && log.isDebugEnabled()) {
            log.debug("No global secret provider is configured.");
        }
        if ((repositoriesString = MiscellaneousUtil.getProperty(configurationProperties, PROP_SECRET_REPOSITORIES, null)) == null || "".equals(repositoriesString)) {
            if (log.isDebugEnabled()) {
                log.debug("No secret repositories have been configured");
            }
            return;
        }
        String[] repositories = repositoriesString.split(",");
        if (repositories == null || repositories.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug("No secret repositories have been configured");
            }
            return;
        }
        IdentityKeyStoreInformation identityInformation = KeyStoreInformationFactory.createIdentityKeyStoreInformation(properties);
        TrustKeyStoreInformation trustInformation = KeyStoreInformationFactory.createTrustKeyStoreInformation(properties);
        String identityKeyPass = null;
        String identityStorePass = null;
        String trustStorePass = null;
        if (identityInformation != null) {
            identityKeyPass = identityInformation.getKeyPasswordProvider().getResolvedSecret();
            identityStorePass = identityInformation.getKeyStorePasswordProvider().getResolvedSecret();
        }
        if (trustInformation != null) {
            trustStorePass = trustInformation.getKeyStorePasswordProvider().getResolvedSecret();
        }
        if (!this.validatePasswords(identityStorePass, identityKeyPass, trustStorePass)) {
            if (log.isDebugEnabled()) {
                log.info("Either Identity or Trust keystore password is mandatory in order to initialized secret manager.");
            }
            return;
        }
        IdentityKeyStoreWrapper identityKeyStoreWrapper = new IdentityKeyStoreWrapper();
        identityKeyStoreWrapper.init(identityInformation, identityKeyPass);
        TrustKeyStoreWrapper trustKeyStoreWrapper = new TrustKeyStoreWrapper();
        if (trustInformation != null) {
            trustKeyStoreWrapper.init(trustInformation);
        }
        SecretRepository currentParent = null;
        for (String secretRepo : repositories) {
            StringBuffer sb = new StringBuffer();
            sb.append(PROP_SECRET_REPOSITORIES);
            sb.append(DOT);
            sb.append(secretRepo);
            String id = sb.toString();
            sb.append(DOT);
            sb.append(PROP_PROVIDER);
            String provider = MiscellaneousUtil.getProperty(configurationProperties, sb.toString(), null);
            if (provider == null || "".equals(provider)) {
                SecretManager.handleException("Repository provider cannot be null ");
            }
            if (log.isDebugEnabled()) {
                log.debug("Initiating a File Based Secret Repository");
            }
            try {
                Class<?> aClass = this.getClass().getClassLoader().loadClass(provider.trim());
                Object instance = aClass.newInstance();
                if (instance instanceof SecretRepositoryProvider) {
                    SecretRepository secretRepository = ((SecretRepositoryProvider)instance).getSecretRepository(identityKeyStoreWrapper, trustKeyStoreWrapper);
                    secretRepository.init(configurationProperties, id);
                    if (this.parentRepository == null) {
                        this.parentRepository = secretRepository;
                    }
                    secretRepository.setParent(currentParent);
                    currentParent = secretRepository;
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Successfully Initiate a Secret Repository provided by : " + provider);
                    continue;
                }
                SecretManager.handleException("Invalid class as SecretRepositoryProvider : Class Name : " + provider);
            }
            catch (ClassNotFoundException e) {
                SecretManager.handleException("A Secret Provider cannot be found for class name : " + provider);
            }
            catch (IllegalAccessException e) {
                SecretManager.handleException("Error creating a instance from class : " + provider);
            }
            catch (InstantiationException e) {
                SecretManager.handleException("Error creating a instance from class : " + provider);
            }
        }
        this.initialized = true;
    }

    public String getSecret(String alias) {
        if (!this.initialized || this.parentRepository == null) {
            if (log.isDebugEnabled()) {
                log.debug("There is no secret repository. Returning alias itself");
            }
            return alias;
        }
        return this.parentRepository.getSecret(alias);
    }

    public String getEncryptedData(String alias) {
        if (!this.initialized || this.parentRepository == null) {
            if (log.isDebugEnabled()) {
                log.debug("There is no secret repository. Returning alias itself");
            }
            return alias;
        }
        return this.parentRepository.getEncryptedData(alias);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void shoutDown() {
        this.parentRepository = null;
        this.initialized = false;
    }

    private static void handleException(String msg) {
        log.error(msg);
        throw new SecureVaultException(msg);
    }

    private boolean validatePasswords(String identityStorePass, String identityKeyPass, String trustStorePass) {
        boolean isValid = false;
        if (trustStorePass != null && !"".equals(trustStorePass)) {
            if (log.isDebugEnabled()) {
                log.debug("Trust Store Password cannot be found.");
            }
            isValid = true;
        } else if (identityStorePass != null && !"".equals(identityStorePass) && identityKeyPass != null && !"".equals(identityKeyPass)) {
            if (log.isDebugEnabled()) {
                log.debug("Identity Store Password and Identity Store private key Password cannot be found.");
            }
            isValid = true;
        }
        return isValid;
    }

    public String getGlobalSecretProvider() {
        return this.globalSecretProvider;
    }
}

