/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ChunkedOutputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.ContentLengthOutputStream;
import org.apache.http.impl.io.HttpRequestParser;
import org.apache.http.impl.io.HttpResponseWriter;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.impl.io.IdentityOutputStream;
import org.apache.http.impl.io.SocketInputBuffer;
import org.apache.http.impl.io.SocketOutputBuffer;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class AxisHttpConnectionImpl
implements AxisHttpConnection {
    private static final Log HEADERLOG = LogFactory.getLog("org.apache.axis2.transport.http.server.wire");
    private final Socket socket;
    private final SessionOutputBuffer outbuffer;
    private final SessionInputBuffer inbuffer;
    private final HttpMessageParser requestParser;
    private final HttpMessageWriter responseWriter;
    private final ContentLengthStrategy contentLenStrategy;
    private OutputStream out = null;
    private InputStream in = null;

    public AxisHttpConnectionImpl(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        int buffersize = HttpConnectionParams.getSocketBufferSize(params);
        this.socket = socket;
        this.outbuffer = new SocketOutputBuffer(socket, buffersize, params);
        this.inbuffer = new SocketInputBuffer(socket, buffersize, params);
        this.contentLenStrategy = new StrictContentLengthStrategy();
        this.requestParser = new HttpRequestParser(this.inbuffer, null, new DefaultHttpRequestFactory(), params);
        this.responseWriter = new HttpResponseWriter(this.outbuffer, null, params);
    }

    @Override
    public void close() throws IOException {
        this.outbuffer.flush();
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.socket.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public boolean isStale() {
        try {
            this.inbuffer.isDataAvailable(1);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    @Override
    public void shutdown() throws IOException {
        Socket tmpsocket = this.socket;
        if (tmpsocket != null) {
            tmpsocket.close();
        }
    }

    @Override
    public HttpRequest receiveRequest() throws HttpException, IOException {
        HttpRequest request = (HttpRequest)this.requestParser.parse();
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug(">> " + request.getRequestLine().toString());
            HeaderIterator it = request.headerIterator();
            while (it.hasNext()) {
                HEADERLOG.debug(">> " + it.nextHeader().toString());
            }
        }
        this.in = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            long len = this.contentLenStrategy.determineLength(request);
            this.in = len == -2L ? new ChunkedInputStream(this.inbuffer) : (len == -1L ? new IdentityInputStream(this.inbuffer) : new ContentLengthInputStream(this.inbuffer, len));
        }
        return request;
    }

    @Override
    public void sendResponse(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug("<< " + response.getStatusLine().toString());
            HeaderIterator it = response.headerIterator();
            while (it.hasNext()) {
                HEADERLOG.debug("<< " + it.nextHeader().toString());
            }
        }
        this.responseWriter.write(response);
        this.out = null;
        ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long len = entity.getContentLength();
            this.out = entity.isChunked() && ver.greaterEquals(HttpVersion.HTTP_1_1) ? new ChunkedOutputStream(this.outbuffer) : (len >= 0L ? new ContentLengthOutputStream(this.outbuffer, len) : new IdentityOutputStream(this.outbuffer));
        } else {
            this.outbuffer.flush();
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        } else {
            this.outbuffer.flush();
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    @Override
    public int getSocketTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException ex) {
            return -1;
        }
    }

    @Override
    public void setSocketTimeout(int timeout) {
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return null;
    }

    @Override
    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    @Override
    public int getRemotePort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.isOpen()) {
            buffer.append(this.socket.getInetAddress());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

