/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.event.application.GroupMaintenanceModeEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class GroupMaintenanceModeProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(GroupMaintenanceModeProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (GroupMaintenanceModeEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            GroupMaintenanceModeEvent event = (GroupMaintenanceModeEvent)MessagingUtil.jsonToObject(message, GroupMaintenanceModeEvent.class);
            ApplicationsUpdater.acquireWriteLockForApplication(event.getAppId());
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplication(event.getAppId());
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(GroupMaintenanceModeEvent event, Applications applications) {
        this.notifyEventListeners(event);
        return true;
    }
}

