/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.ApplicationStatus;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.domain.instance.ApplicationInstance;
import org.apache.stratos.messaging.event.application.ApplicationInstanceInactivatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationInstanceInactivatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationInstanceInactivatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (ApplicationInstanceInactivatedEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            ApplicationInstanceInactivatedEvent event = (ApplicationInstanceInactivatedEvent)MessagingUtil.jsonToObject(message, ApplicationInstanceInactivatedEvent.class);
            ApplicationsUpdater.acquireWriteLockForApplication(event.getAppId());
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplication(event.getAppId());
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ApplicationInstanceInactivatedEvent event, Applications applications) {
        Application application = applications.getApplication(event.getAppId());
        if (application == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Application does not exist: [service] %s", event.getAppId()));
            }
            return false;
        }
        ApplicationInstance context = (ApplicationInstance)application.getInstanceContexts(event.getInstanceId());
        if (context == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Application instance not exists in group: [application-id] %s[instance-id] %s", event.getAppId(), event.getInstanceId()));
            }
            return false;
        }
        ApplicationStatus status = ApplicationStatus.Inactive;
        if (!context.isStateTransitionValid(status)) {
            log.error((Object)("Invalid state transfer from [ " + context.getStatus() + " ] to [ " + status + " ]"));
        }
        context.setStatus(status);
        this.notifyEventListeners(event);
        return true;
    }
}

