/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect.amqp;

import javax.jms.Topic;
import javax.jms.TopicSession;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.RetryTimer;
import org.apache.stratos.messaging.broker.connect.TopicSubscriber;
import org.apache.stratos.messaging.broker.connect.amqp.AmqpTopicConnector;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.domain.exception.MessagingException;

public class AmqpTopicSubscriber
extends AmqpTopicConnector
implements TopicSubscriber {
    protected static final Log log = LogFactory.getLog(AmqpTopicSubscriber.class);
    private final MessageListener messageListener;
    private final String topicName;

    public AmqpTopicSubscriber(MessageListener messageListener, String topicName) {
        this.messageListener = messageListener;
        this.topicName = topicName;
        this.create();
    }

    @Override
    public void subscribe() {
        try {
            TopicSession topicSession = this.newSession();
            Topic topic = this.lookupTopic(this.topicName);
            if (topic == null) {
                topic = topicSession.createTopic(this.topicName);
            }
            javax.jms.TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
            topicSubscriber.setMessageListener(new javax.jms.MessageListener(){

                public void onMessage(javax.jms.Message message) {
                    try {
                        String topicName = null;
                        String messageText = null;
                        if (message instanceof ActiveMQTextMessage) {
                            ActiveMQTextMessage textMessage = (ActiveMQTextMessage)message;
                            topicName = textMessage.getDestination().getPhysicalName();
                            messageText = textMessage.getText();
                        } else if (message instanceof ActiveMQBytesMessage) {
                            ActiveMQBytesMessage bytesMessage = (ActiveMQBytesMessage)message;
                            topicName = bytesMessage.getDestination().getPhysicalName();
                            messageText = new String(bytesMessage.getContent().data);
                        } else {
                            throw new RuntimeException(String.format("Could not receive message, unknown JMS message type: %s", message.getClass().getName()));
                        }
                        Message message_ = new Message(topicName, messageText);
                        AmqpTopicSubscriber.this.messageListener.messageReceived(message_);
                    }
                    catch (Exception e) {
                        String error = "An error occurred when receiving message";
                        log.error((Object)error, (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            String message = "Could not subscribe to topic: " + this.topicName;
            log.error((Object)message, (Throwable)e);
            throw new MessagingException(message, e);
        }
    }

    @Override
    protected void reconnect() {
        RetryTimer retryTimer = new RetryTimer();
        boolean connected = false;
        while (!connected) {
            try {
                long interval = retryTimer.getNextInterval();
                log.info((Object)String.format("Topic subscriber will try to reconnect in %d seconds: [topic-name] %s", interval / 1000L, this.topicName));
                Thread.sleep(interval);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                this.disconnect();
                this.create();
                this.connect();
                this.subscribe();
                connected = true;
                log.info((Object)String.format("Topic subscriber reconnected: [topic-name] %s", this.topicName));
            }
            catch (Exception e) {
                String message = "Could not reconnect to message broker";
                log.warn((Object)message, (Throwable)e);
            }
        }
    }
}

