/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc;

import java.io.InputStream;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.jdbc.realm.InMemoryRealmService;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.service.RealmService;

public class InMemoryEmbeddedRegistryService
extends EmbeddedRegistryService {
    private RealmService realmService = new InMemoryRealmService();

    public InMemoryEmbeddedRegistryService() throws RegistryException {
        this.registryContext = RegistryContext.getBaseInstance(this.realmService);
        this.registryContext.setSetup(true);
        this.registryContext.selectDBConfig("h2-db");
        super.configure(this.realmService);
    }

    public InMemoryEmbeddedRegistryService(InputStream configStream) throws RegistryException {
        this.registryContext = RegistryContext.getBaseInstance(configStream, this.realmService);
        this.registryContext.setSetup(true);
        this.registryContext.selectDBConfig("h2-db");
        super.configure(this.realmService);
    }

    public RealmConfiguration getBootstrapRealmConfiguration() {
        return this.realmService.getBootstrapRealmConfiguration();
    }

    public RealmService getRealmService() {
        return this.realmService;
    }
}

