/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.CheckReplicaVersion;
import com.hazelcast.partition.PartitionImpl;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

final class SyncReplicaVersion
extends Operation
implements PartitionAwareOperation {
    private final int syncReplicaIndex;
    private final Callback<Object> callback;
    private final boolean sync;

    public SyncReplicaVersion(int syncReplicaIndex, Callback<Object> callback) {
        this.syncReplicaIndex = syncReplicaIndex;
        this.callback = callback;
        this.sync = callback != null;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        PartitionServiceImpl partitionService = (PartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.syncReplicaIndex;
        PartitionImpl partition = partitionService.getPartition(partitionId);
        Address target = partition.getReplicaAddress(replicaIndex);
        if (target != null) {
            long[] currentVersions = partitionService.getPartitionReplicaVersions(partitionId);
            NodeEngine nodeEngine = this.getNodeEngine();
            CheckReplicaVersion op = new CheckReplicaVersion(currentVersions[replicaIndex], this.sync);
            op.setPartitionId(partitionId).setReplicaIndex(replicaIndex).setServiceName("hz:core:partitionService");
            OperationService operationService = nodeEngine.getOperationService();
            if (this.sync) {
                operationService.createInvocationBuilder("hz:core:partitionService", (Operation)op, target).setCallback(this.callback).setTryCount(10).setTryPauseMillis(250L).build().invoke();
            } else {
                operationService.send((Operation)op, target);
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SyncReplicaVersion{");
        sb.append("partitionId=").append(this.getPartitionId());
        sb.append(", replicaIndex=").append(this.syncReplicaIndex);
        sb.append('}');
        return sb.toString();
    }
}

