/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.util.Stack;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMXMLStreamReaderValidator
implements OMXMLStreamReader {
    private static Log log = LogFactory.getLog(OMXMLStreamReaderValidator.class);
    private static boolean IS_DEBUG_ENABLED = log.isDebugEnabled();
    private static boolean IS_ADV_DEBUG_ENABLED = false;
    private final OMXMLStreamReader delegate;
    private boolean throwExceptions = false;
    private Stack stack = new Stack();

    public OMXMLStreamReaderValidator(OMXMLStreamReader delegate, boolean throwExceptions) {
        this.delegate = delegate;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public int next() throws XMLStreamException {
        int event = this.delegate.next();
        this.logParserState();
        switch (event) {
            case 1: {
                this.stack.push(this.delegate.getName());
                break;
            }
            case 2: {
                QName delegateQName = this.delegate.getName();
                if (this.stack.isEmpty()) {
                    this.reportMismatchedEndElement(null, delegateQName);
                    break;
                }
                QName expectedQName = (QName)this.stack.pop();
                if (expectedQName.equals(delegateQName)) break;
                this.reportMismatchedEndElement(expectedQName, delegateQName);
                break;
            }
        }
        return event;
    }

    private void reportMismatchedEndElement(QName expectedQName, QName delegateQName) {
        String text = null;
        text = expectedQName == null ? "An END_ELEMENT event for " + delegateQName + " was encountered, but the START_ELEMENT stack is empty." : "An END_ELEMENT event for " + delegateQName + " was encountered, but this doesn't match the corresponding START_ELEMENT " + expectedQName + " event.";
        if (IS_DEBUG_ENABLED) {
            log.debug((Object)text);
        }
        if (this.throwExceptions) {
            throw new OMException(text);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public int getAttributeCount() {
        return this.delegate.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int arg0) {
        return this.delegate.getAttributeLocalName(arg0);
    }

    @Override
    public QName getAttributeName(int arg0) {
        return this.delegate.getAttributeName(arg0);
    }

    @Override
    public String getAttributeNamespace(int arg0) {
        return this.delegate.getAttributeNamespace(arg0);
    }

    @Override
    public String getAttributePrefix(int arg0) {
        return this.delegate.getAttributePrefix(arg0);
    }

    @Override
    public String getAttributeType(int arg0) {
        return this.delegate.getAttributeType(arg0);
    }

    @Override
    public String getAttributeValue(int arg0) {
        return this.delegate.getAttributeValue(arg0);
    }

    @Override
    public String getAttributeValue(String arg0, String arg1) {
        return this.delegate.getAttributeValue(arg0, arg1);
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.delegate.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.delegate.getElementText();
    }

    @Override
    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    @Override
    public int getEventType() {
        return this.delegate.getEventType();
    }

    @Override
    public String getLocalName() {
        return this.delegate.getLocalName();
    }

    @Override
    public Location getLocation() {
        return this.delegate.getLocation();
    }

    @Override
    public QName getName() {
        return this.delegate.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        return this.delegate.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int arg0) {
        return this.delegate.getNamespacePrefix(arg0);
    }

    @Override
    public String getNamespaceURI() {
        return this.delegate.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(int arg0) {
        return this.delegate.getNamespaceURI(arg0);
    }

    @Override
    public String getNamespaceURI(String arg0) {
        return this.delegate.getNamespaceURI(arg0);
    }

    @Override
    public String getPIData() {
        return this.delegate.getPIData();
    }

    @Override
    public String getPITarget() {
        return this.delegate.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.delegate.getProperty(arg0);
    }

    @Override
    public String getText() {
        return this.delegate.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.delegate.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        return this.delegate.getTextCharacters(arg0, arg1, arg2, arg3);
    }

    @Override
    public int getTextLength() {
        return this.delegate.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this.delegate.getTextStart();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public boolean hasName() {
        return this.delegate.hasName();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.delegate.hasNext();
    }

    @Override
    public boolean hasText() {
        return this.delegate.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int arg0) {
        return this.delegate.isAttributeSpecified(arg0);
    }

    @Override
    public boolean isCharacters() {
        return this.delegate.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this.delegate.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return this.delegate.isStandalone();
    }

    @Override
    public boolean isStartElement() {
        return this.delegate.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.delegate.isWhiteSpace();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return this.delegate.nextTag();
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        this.delegate.require(arg0, arg1, arg2);
    }

    @Override
    public boolean standaloneSet() {
        return this.delegate.standaloneSet();
    }

    protected void logParserState() {
        if (IS_ADV_DEBUG_ENABLED) {
            int currentEvent = this.delegate.getEventType();
            switch (currentEvent) {
                case 1: {
                    log.trace((Object)"START_ELEMENT: ");
                    log.trace((Object)("  QName: " + this.delegate.getName()));
                    break;
                }
                case 7: {
                    log.trace((Object)"START_DOCUMENT: ");
                    break;
                }
                case 4: {
                    log.trace((Object)"CHARACTERS: ");
                    log.trace((Object)("[" + this.delegate.getText() + "]"));
                    break;
                }
                case 12: {
                    log.trace((Object)"CDATA: ");
                    log.trace((Object)("[" + this.delegate.getText() + "]"));
                    break;
                }
                case 2: {
                    log.trace((Object)"END_ELEMENT: ");
                    log.trace((Object)("  QName: " + this.delegate.getName()));
                    break;
                }
                case 8: {
                    log.trace((Object)"END_DOCUMENT: ");
                    break;
                }
                case 6: {
                    log.trace((Object)"SPACE: ");
                    log.trace((Object)("[" + this.delegate.getText() + "]"));
                    break;
                }
                case 5: {
                    log.trace((Object)"COMMENT: ");
                    log.trace((Object)("[" + this.delegate.getText() + "]"));
                    break;
                }
                case 11: {
                    log.trace((Object)"DTD: ");
                    log.trace((Object)("[" + this.delegate.getText() + "]"));
                    break;
                }
                case 3: {
                    log.trace((Object)"PROCESSING_INSTRUCTION: ");
                    log.trace((Object)("   [" + this.delegate.getPITarget() + "][" + this.delegate.getPIData() + "]"));
                    break;
                }
                case 9: {
                    log.trace((Object)"ENTITY_REFERENCE: ");
                    log.trace((Object)("    " + this.delegate.getLocalName() + "[" + this.delegate.getText() + "]"));
                    break;
                }
                default: {
                    log.trace((Object)("UNKNOWN_STATE: " + currentEvent));
                }
            }
        }
    }

    @Override
    public DataHandler getDataHandler(String blobcid) {
        return this.delegate.getDataHandler(blobcid);
    }

    @Override
    public boolean isInlineMTOM() {
        return this.delegate.isInlineMTOM();
    }

    @Override
    public void setInlineMTOM(boolean value) {
        this.delegate.setInlineMTOM(value);
    }
}

