/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.typemapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.Day;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.types.Month;
import org.apache.axis2.databinding.types.MonthDay;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Year;
import org.apache.axis2.databinding.types.YearMonth;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.description.AxisService;

public class SimpleTypeMapper {
    private static final String STRING = "java.lang.String";
    private static final String W_INT = "java.lang.Integer";
    private static final String W_DOUBLE = "java.lang.Double";
    private static final String W_LONG = "java.lang.Long";
    private static final String W_BYTE = "java.lang.Byte";
    private static final String W_SHORT = "java.lang.Short";
    private static final String W_BOOLEAN = "java.lang.Boolean";
    private static final String W_CHAR = "java.lang.Character";
    private static final String W_FLOAT = "java.lang.Float";
    private static final String W_CALENDAR = "java.util.Calendar";
    private static final String W_DATE = "java.util.Date";
    private static final String W_URI = URI.class.getName();
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE = "byte";
    private static final String DOUBLE = "double";
    private static final String SHORT = "short";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String CHAR = "char";
    private static final String BIG_DECIMAL = "java.math.BigDecimal";
    private static final String BIG_INTEGER = "java.math.BigInteger";
    private static final String DAY = "org.apache.axis2.databinding.types.Day";
    private static final String DURATION = "org.apache.axis2.databinding.types.Duration";
    private static final String MONTH = "org.apache.axis2.databinding.types.Month";
    private static final String MONTH_DAY = "org.apache.axis2.databinding.types.MonthDay";
    private static final String TIME = "org.apache.axis2.databinding.types.Time";
    private static final String YEAR = "org.apache.axis2.databinding.types.Year";
    private static final String YEAR_MONTH = "org.apache.axis2.databinding.types.YearMonth";

    public static Object getSimpleTypeObject(Class parameter, OMElement value) {
        String name = parameter.getName();
        String text = value.getText();
        if (name.equals(STRING)) {
            return text;
        }
        if (text == null || text.length() == 0) {
            return null;
        }
        if (name.equals(INT)) {
            return new Integer(text);
        }
        if (name.equals(BOOLEAN)) {
            return ConverterUtil.convertToBoolean(text);
        }
        if (name.equals(BYTE)) {
            return new Byte(text);
        }
        if (name.equals(DOUBLE)) {
            return new Double(text);
        }
        if (name.equals(SHORT)) {
            return new Short(text);
        }
        if (name.equals(LONG)) {
            return new Long(text);
        }
        if (name.equals(FLOAT)) {
            return new Float(text);
        }
        if (name.equals(CHAR)) {
            return Character.valueOf(text.toCharArray()[0]);
        }
        if (name.equals(W_INT)) {
            return new Integer(text);
        }
        if (name.equals(W_BOOLEAN)) {
            return Boolean.valueOf(text);
        }
        if (name.equals(W_BYTE)) {
            return new Byte(text);
        }
        if (name.equals(W_DOUBLE)) {
            return new Double(text);
        }
        if (name.equals(W_SHORT)) {
            return new Short(text);
        }
        if (name.equals(W_LONG)) {
            return new Long(text);
        }
        if (name.equals(W_FLOAT)) {
            return new Float(text);
        }
        if (name.equals(W_CHAR)) {
            return Character.valueOf(text.toCharArray()[0]);
        }
        if (name.equals(W_CALENDAR)) {
            return SimpleTypeMapper.makeCalendar(text);
        }
        if (name.equals(W_DATE)) {
            return SimpleTypeMapper.makeDate(text);
        }
        if (name.equals(BIG_DECIMAL)) {
            return new BigDecimal(text);
        }
        if (name.equals(BIG_INTEGER)) {
            return new BigInteger(text);
        }
        if (name.equals(DAY)) {
            return new Day(text);
        }
        if (name.equals(DURATION)) {
            return new Duration(text);
        }
        if (name.equals(MONTH)) {
            return new Month(text);
        }
        if (name.equals(MONTH_DAY)) {
            return new MonthDay(text);
        }
        if (name.equals(TIME)) {
            return new Time(text);
        }
        if (name.equals(YEAR)) {
            return new Year(text);
        }
        if (name.equals(YEAR_MONTH)) {
            return new YearMonth(text);
        }
        if (name.equals(W_URI)) {
            try {
                return new URI(text);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(" Invalid URI " + text, e);
            }
        }
        return null;
    }

    public static ArrayList getArrayList(OMElement element, String localName) {
        Iterator childitr = element.getChildrenWithName(new QName(localName));
        ArrayList list = new ArrayList();
        while (childitr.hasNext()) {
            Object o = childitr.next();
            list.add(o);
        }
        return list;
    }

    public static HashSet getHashSet(OMElement element, String localName) {
        Iterator childitr = element.getChildrenWithName(new QName(localName));
        HashSet<String> list = new HashSet<String>();
        while (childitr.hasNext()) {
            OMElement o = (OMElement)childitr.next();
            list.add(o.getText());
        }
        return list;
    }

    public static DataHandler getDataHandler(OMElement element) {
        OMNode node = element.getFirstOMChild();
        if (node instanceof OMText) {
            OMText txt = (OMText)node;
            if (txt.isOptimized()) {
                return (DataHandler)txt.getDataHandler();
            }
            return (DataHandler)DataHandlerUtils.getDataHandlerFromText((String)txt.getText(), null);
        }
        return null;
    }

    public static ArrayList getArrayList(OMElement element) {
        Iterator childitr = element.getChildren();
        ArrayList list = new ArrayList();
        while (childitr.hasNext()) {
            Object o = childitr.next();
            list.add(o);
        }
        return list;
    }

    public static boolean isSimpleType(Object obj) {
        String objClassName = obj.getClass().getName();
        return obj instanceof Calendar || obj instanceof Date || SimpleTypeMapper.isSimpleType(objClassName);
    }

    public static boolean isSimpleType(Class obj) {
        String objClassName = obj.getName();
        return SimpleTypeMapper.isSimpleType(objClassName);
    }

    public static boolean isDataHandler(Class obj) {
        return obj.isAssignableFrom(DataHandler.class) && !obj.equals(Object.class);
    }

    public static boolean isHashSet(Class obj) {
        return HashSet.class.isAssignableFrom(obj);
    }

    public static boolean isCollection(Class obj) {
        return Collection.class.isAssignableFrom(obj);
    }

    public static boolean isSimpleType(String objClassName) {
        if (objClassName.equals(STRING)) {
            return true;
        }
        if (objClassName.equals(INT)) {
            return true;
        }
        if (objClassName.equals(BOOLEAN)) {
            return true;
        }
        if (objClassName.equals(BYTE)) {
            return true;
        }
        if (objClassName.equals(DOUBLE)) {
            return true;
        }
        if (objClassName.equals(SHORT)) {
            return true;
        }
        if (objClassName.equals(LONG)) {
            return true;
        }
        if (objClassName.equals(FLOAT)) {
            return true;
        }
        if (objClassName.equals(CHAR)) {
            return true;
        }
        if (objClassName.equals(W_INT)) {
            return true;
        }
        if (objClassName.equals(W_BOOLEAN)) {
            return true;
        }
        if (objClassName.equals(W_BYTE)) {
            return true;
        }
        if (objClassName.equals(W_DOUBLE)) {
            return true;
        }
        if (objClassName.equals(W_SHORT)) {
            return true;
        }
        if (objClassName.equals(W_LONG)) {
            return true;
        }
        if (objClassName.equals(W_FLOAT)) {
            return true;
        }
        if (objClassName.equals(W_CALENDAR)) {
            return true;
        }
        if (objClassName.equals(W_DATE)) {
            return true;
        }
        if (objClassName.equals(W_URI)) {
            return true;
        }
        return objClassName.equals(BIG_DECIMAL) || objClassName.equals(BIG_INTEGER) || objClassName.equals(DAY) || objClassName.equals(DURATION) || objClassName.equals(MONTH) || objClassName.equals(MONTH_DAY) || objClassName.equals(TIME) || objClassName.equals(YEAR) || objClassName.equals(YEAR_MONTH) || objClassName.equals(W_CHAR);
    }

    public static String getStringValue(Object obj) {
        if (obj instanceof Float || obj instanceof Double) {
            double data = obj instanceof Float ? ((Float)obj).doubleValue() : ((Double)obj).doubleValue();
            if (Double.isNaN(data)) {
                return "NaN";
            }
            if (data == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (data == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return obj.toString();
        }
        if (obj instanceof Calendar) {
            Calendar calendar = (Calendar)obj;
            return ConverterUtil.convertToString(calendar);
        }
        if (obj instanceof Date) {
            AxisService axisServce;
            SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
            MessageContext messageContext = MessageContext.getCurrentMessageContext();
            if (messageContext != null && (axisServce = messageContext.getAxisService()).getParameter("TimeZone") != null) {
                zulu.setTimeZone(TimeZone.getTimeZone((String)axisServce.getParameter("TimeZone").getValue()));
            }
            return zulu.format(obj);
        }
        if (obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).toPlainString();
        }
        return obj.toString();
    }

    public static Object makeCalendar(String source) {
        return ConverterUtil.convertToDateTime(source);
    }

    public static Object makeDate(String source) {
        return ConverterUtil.convertToDate(source);
    }
}

