/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.dataaccess.DataAccessManager;
import org.wso2.carbon.registry.core.dataaccess.QueryProcessor;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCCommentsDAO;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCRatingsDAO;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataaccess.TenantAwareSQLTransformer;
import org.wso2.carbon.registry.core.jdbc.dataobjects.RatingDO;
import org.wso2.carbon.registry.core.jdbc.dataobjects.TaggingDO;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class SQLQueryProcessor
implements QueryProcessor {
    private static final Log log = LogFactory.getLog(SQLQueryProcessor.class);
    private ResourceDAO resourceDAO;
    private CommentsDAO commentsDAO;
    private RatingsDAO ratingsDAO;
    private TagsDAO tagsDAO;
    protected DataSource dataSource;

    public SQLQueryProcessor(DataAccessManager dataAccessManager) {
        if (dataAccessManager instanceof JDBCDataAccessManager) {
            this.dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
        } else {
            log.error((Object)"Invalid data access manager.");
        }
        this.resourceDAO = dataAccessManager.getDAOManager().getResourceDAO();
        this.commentsDAO = dataAccessManager.getDAOManager().getCommentsDAO(StaticConfiguration.isVersioningComments());
        this.ratingsDAO = dataAccessManager.getDAOManager().getRatingsDAO(StaticConfiguration.isVersioningRatings());
        this.tagsDAO = dataAccessManager.getDAOManager().getTagsDAO(StaticConfiguration.isVersioningTags());
    }

    @Override
    public Collection executeQuery(Registry registry, Resource query, Map parameters) throws RegistryException {
        Collection resultCollection = null;
        ResultSet results = null;
        Statement s = null;
        try {
            String sqlString;
            Object obj = query.getContent();
            if (parameters != null) {
                Object resultType;
                Object querySQL = parameters.get("query");
                if (querySQL != null) {
                    obj = querySQL;
                }
                if ((resultType = parameters.get("resultType")) != null && resultType instanceof String) {
                    query.setProperty("resultType", (String)resultType);
                }
            }
            if (obj instanceof String) {
                sqlString = (String)obj;
            } else if (obj instanceof byte[]) {
                sqlString = RegistryUtils.decodeBytes((byte[])obj);
            } else {
                throw new RegistryException("Unable to execute query at " + query.getPath() + ".Found resource content of type " + (obj == null ? "null" : obj.getClass().getName()) + ".Expected java.lang.String or byte[]");
            }
            JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
            TenantAwareSQLTransformer transformer = new TenantAwareSQLTransformer(sqlString);
            String transformedQuery = transformer.getTransformedQuery();
            int transformedParameterCount = transformer.getAdditionalParameterCount();
            s = conn.prepareStatement(transformedQuery);
            int nextParameterIndex = 0;
            for (int i = 0; i < transformedParameterCount; ++i) {
                s.setInt(++nextParameterIndex, CurrentSession.getTenantId());
            }
            if (parameters != null) {
                List<String> exclusions = Arrays.asList("content", "query", "mediaType", "resultType");
                for (Object parameterNumberObject : parameters.keySet()) {
                    String parameterNumber = (String)parameterNumberObject;
                    if (exclusions.contains(parameterNumber)) continue;
                    Object parameterValue = parameters.get(parameterNumber);
                    s.setObject(Integer.parseInt(parameterNumber) + nextParameterIndex, parameterValue);
                }
            }
            results = s.executeQuery();
            String resultType = query.getProperty("resultType");
            if (resultType == null) {
                resultType = "Resource";
                query.setProperty("resultType", resultType);
            }
            if (resultType.equals("Resource")) {
                resultCollection = this.fillResourcesCollection(results);
            } else if (resultType.equals("ResourceUUID")) {
                resultCollection = this.fillResourceUUIDCollection(results);
            } else if (resultType.equals("Comments")) {
                resultCollection = this.fillCommentsCollection(results, conn);
            } else if (resultType.equals("Ratings")) {
                resultCollection = this.fillRatingsCollection(results);
            } else if (resultType.equals("Tags")) {
                resultCollection = this.fillTagsCollection(results);
            } else if (resultType.equals("TagSummary")) {
                resultCollection = this.fillTagSummaryCollection(results);
            }
            if (resultCollection == null) {
                String msg = "Unknown result type: " + resultType + " defined for the query: " + sqlString + (query.getPath() != null ? " located in path: " + query.getPath() : "");
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
        }
        catch (SQLException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    String msg = "Failed to close the result set. " + e.getMessage();
                    log.error((Object)msg, (Throwable)e);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    log.error((Object)("Failed to close the statement. " + e.getMessage()));
                }
            }
        }
        if (resultCollection != null && "Resource".equals(query.getProperty("resultType"))) {
            String[] resultPaths;
            ArrayList<String> filteredResults = new ArrayList<String>();
            for (String resultPath : resultPaths = resultCollection.getChildren()) {
                if (!AuthorizationUtils.authorize(resultPath, "http://www.wso2.org/projects/registry/actions/get")) continue;
                filteredResults.add(resultPath);
            }
            String[] filteredContent = filteredResults.toArray(new String[filteredResults.size()]);
            resultCollection.setContent(filteredContent);
        }
        return resultCollection;
    }

    private Collection fillResourcesCollection(ResultSet results) throws SQLException, RegistryException {
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>();
        while (results.next()) {
            String resourceName;
            int pathId = results.getInt("REG_PATH_ID");
            String path = this.resourceDAO.getPath(pathId, resourceName = results.getString("REG_NAME"), false);
            if (path == null) continue;
            pathSet.add(path);
        }
        String[] paths = pathSet.toArray(new String[pathSet.size()]);
        return new CollectionImpl(paths);
    }

    private Collection fillCommentsCollection(ResultSet results, Connection conn) throws SQLException, RegistryException {
        if (!(this.commentsDAO instanceof JDBCCommentsDAO)) {
            String msg = "Failed to list of comments. Invalid comments data access object.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        ArrayList<Long> commentIDs = new ArrayList<Long>();
        while (results.next()) {
            long commentID = results.getLong("REG_COMMENT_ID");
            commentIDs.add(commentID);
        }
        String[] commentPaths = ((JDBCCommentsDAO)this.commentsDAO).getResourcePathsOfComments(commentIDs.toArray(new Long[commentIDs.size()]), conn);
        return new CollectionImpl(commentPaths);
    }

    private Collection fillRatingsCollection(ResultSet results) throws SQLException, RegistryException {
        if (!(this.ratingsDAO instanceof JDBCRatingsDAO)) {
            String msg = "Failed to list of ratings. Invalid ratings data access object.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        ArrayList<String> ratingPathList = new ArrayList<String>();
        while (results.next()) {
            long ratingID = results.getLong("REG_RATING_ID");
            RatingDO ratingDAO = ((JDBCRatingsDAO)this.ratingsDAO).getRating(ratingID);
            String ratingPath = ratingDAO.getResourcePath() + ";" + "ratings:" + ratingDAO.getRatedUserName();
            ratingPathList.add(ratingPath);
        }
        String[] ratingPaths = ratingPathList.toArray(new String[ratingPathList.size()]);
        return new CollectionImpl(ratingPaths);
    }

    private Collection fillTagsCollection(ResultSet results) throws SQLException, RegistryException {
        ArrayList<String> tagPathList = new ArrayList<String>();
        while (results.next()) {
            long taggingID = results.getLong("REG_TAG_ID");
            TaggingDO taggingDO = this.tagsDAO.getTagging(taggingID);
            String tagPath = taggingDO.getResourcePath() + ";" + "tags:" + taggingDO.getTagName() + ":" + taggingDO.getTaggedUserName();
            tagPathList.add(tagPath);
        }
        String[] tagPaths = tagPathList.toArray(new String[tagPathList.size()]);
        return new CollectionImpl(tagPaths);
    }

    private Collection fillTagSummaryCollection(ResultSet results) throws SQLException, RegistryException {
        ArrayList<String> tagPathList = new ArrayList<String>();
        while (results.next()) {
            String mockPath = results.getString("MOCK_PATH");
            String tagName = results.getString("TAG_NAME");
            int tagOccurrence = results.getInt("USED_COUNT");
            String tagPath = mockPath + ";" + tagName + ":" + String.valueOf(tagOccurrence);
            tagPathList.add(tagPath);
        }
        String[] tagPaths = tagPathList.toArray(new String[tagPathList.size()]);
        return new CollectionImpl(tagPaths);
    }

    private Collection fillResourceUUIDCollection(ResultSet results) throws SQLException, RegistryException {
        ArrayList<String> uuidList = new ArrayList<String>();
        while (results.next()) {
            String mockPath = results.getString("MOCK_PATH");
            String resourceUUID = results.getString("REG_UUID");
            String path = mockPath + ";" + resourceUUID;
            if (path == null || uuidList.contains(path)) continue;
            uuidList.add(path);
        }
        String[] paths = uuidList.toArray(new String[uuidList.size()]);
        return new CollectionImpl(paths);
    }
}

