/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import org.wso2.andes.transport.ConnectionException;

public final class ProtocolVersionException
extends ConnectionException {
    private final byte major;
    private final byte minor;

    public ProtocolVersionException(byte major, byte minor, Throwable cause) {
        super(String.format("version mismatch: %s-%s", major, minor), cause);
        this.major = major;
        this.minor = minor;
    }

    public ProtocolVersionException(byte major, byte minor) {
        this(major, minor, null);
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public void rethrow() {
        throw new ProtocolVersionException(this.major, this.minor, (Throwable)this);
    }
}

