/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.MessageRejectCode;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.RangeSet;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageReject
extends Method {
    public static final int TYPE = 1027;
    private short packing_flags = 0;
    private RangeSet transfers;
    private MessageRejectCode code;
    private String text;

    @Override
    public final int getStructType() {
        return 1027;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public MessageReject() {
    }

    public MessageReject(RangeSet transfers, MessageRejectCode code, String text, Option ... _options) {
        if (transfers != null) {
            this.setTransfers(transfers);
        }
        if (code != null) {
            this.setCode(code);
        }
        if (text != null) {
            this.setText(text);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.messageReject(context, this);
    }

    public final boolean hasTransfers() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageReject clearTransfers() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.transfers = null;
        this.dirty = true;
        return this;
    }

    public final RangeSet getTransfers() {
        return this.transfers;
    }

    public final MessageReject setTransfers(RangeSet value) {
        this.transfers = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final MessageReject transfers(RangeSet value) {
        return this.setTransfers(value);
    }

    public final boolean hasCode() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageReject clearCode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.code = null;
        this.dirty = true;
        return this;
    }

    public final MessageRejectCode getCode() {
        return this.code;
    }

    public final MessageReject setCode(MessageRejectCode value) {
        this.code = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final MessageReject code(MessageRejectCode value) {
        return this.setCode(value);
    }

    public final boolean hasText() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final MessageReject clearText() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.text = null;
        this.dirty = true;
        return this;
    }

    public final String getText() {
        return this.text;
    }

    public final MessageReject setText(String value) {
        this.text = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.dirty = true;
        return this;
    }

    public final MessageReject text(String value) {
        return this.setText(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceSet(this.transfers);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint16(this.code.getValue());
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeStr8(this.text);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.transfers = dec.readSequenceSet();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.code = MessageRejectCode.get(dec.readUint16());
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.text = dec.readStr8();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("transfers", this.getTransfers());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("code", (Object)this.getCode());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("text", this.getText());
        }
        return result;
    }
}

