/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology.locking;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.locking.TopologyLock;

public class TopologyLockHierarchy {
    private static final Log log = LogFactory.getLog(TopologyLockHierarchy.class);
    private final TopologyLock completeTopologyLock = new TopologyLock();
    private final TopologyLock serviceLock = new TopologyLock();
    private final Map<String, TopologyLock> serviceNameToTopologyLockMap = new ConcurrentHashMap<String, TopologyLock>();
    private final Map<String, TopologyLock> clusterIdToTopologyLockMap = new ConcurrentHashMap<String, TopologyLock>();
    private static volatile TopologyLockHierarchy topologyLockHierarchy;

    private TopologyLockHierarchy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyLockHierarchy getInstance() {
        if (topologyLockHierarchy != null) return topologyLockHierarchy;
        Class<TopologyLockHierarchy> clazz = TopologyLockHierarchy.class;
        synchronized (TopologyLockHierarchy.class) {
            if (topologyLockHierarchy != null) return topologyLockHierarchy;
            topologyLockHierarchy = new TopologyLockHierarchy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return topologyLockHierarchy;
        }
    }

    public synchronized TopologyLock getTopologyLockForService(String serviceName, boolean forceCreationIfNotFound) {
        TopologyLock topologyLock = this.serviceNameToTopologyLockMap.get(serviceName);
        if (topologyLock == null && forceCreationIfNotFound) {
            topologyLock = new TopologyLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock created for topology service: [service-id] " + serviceName));
            }
            this.serviceNameToTopologyLockMap.put(serviceName, topologyLock);
        }
        return topologyLock;
    }

    public synchronized TopologyLock getTopologyLockForCluster(String clusterId, boolean forceCreationIfNotFound) {
        TopologyLock topologyLock = this.clusterIdToTopologyLockMap.get(clusterId);
        if (topologyLock == null && forceCreationIfNotFound) {
            topologyLock = new TopologyLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock created for topology cluster: [cluster-id] " + clusterId));
            }
            this.clusterIdToTopologyLockMap.put(clusterId, topologyLock);
        }
        return topologyLock;
    }

    public void removeTopologyLockForService(String serviceName) {
        if (this.serviceNameToTopologyLockMap.remove(serviceName) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed lock for service " + serviceName));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Lock already removed for service " + serviceName));
        }
    }

    public void removeTopologyLockForCluster(String clusterId) {
        if (this.clusterIdToTopologyLockMap.remove(clusterId) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed lock for cluster " + clusterId));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Lock already removed for cluster " + clusterId));
        }
    }

    public TopologyLock getServiceLock() {
        return this.serviceLock;
    }

    public TopologyLock getCompleteTopologyLock() {
        return this.completeTopologyLock;
    }
}

