/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.locking.TopologyLockHierarchy;

public class Topology
implements Serializable {
    private static final long serialVersionUID = -2453583548027402122L;
    private final HashMap<String, Cluster> clusterMap;
    private Map<String, Service> serviceMap = new HashMap<String, Service>();
    private boolean initialized;
    private static Log log = LogFactory.getLog(Topology.class);

    public Topology() {
        this.clusterMap = new HashMap();
    }

    public Collection<Service> getServices() {
        return this.serviceMap.values();
    }

    public void addService(Service service) {
        this.serviceMap.put(service.getServiceName(), service);
    }

    public synchronized void addServices(Collection<Service> services) {
        for (Service service : services) {
            this.addService(service);
        }
    }

    public void removeService(Service service) {
        this.serviceMap.remove(service.getServiceName());
        TopologyLockHierarchy.getInstance().removeTopologyLockForService(service.getServiceName());
    }

    public void removeService(String serviceName) {
        this.serviceMap.remove(serviceName);
        TopologyLockHierarchy.getInstance().removeTopologyLockForService(serviceName);
    }

    public Service getService(String serviceName) {
        return this.serviceMap.get(serviceName);
    }

    public boolean serviceExists(String serviceName) {
        return this.serviceMap.containsKey(serviceName);
    }

    public void addToCluterMap(Cluster cluster) {
        this.clusterMap.put(cluster.getClusterId(), cluster);
    }

    public void removeFromClusterMap(String cluserId) {
        this.clusterMap.remove(cluserId);
    }

    public Cluster getCluster(String clusterId) {
        return this.clusterMap.get(clusterId);
    }

    public boolean clusterExist(String clusterId) {
        return this.clusterMap.get(clusterId) != null;
    }

    public void clear() {
        this.serviceMap.clear();
        this.clusterMap.clear();
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String toString() {
        return "Topology [serviceMap=" + this.serviceMap + ", initialized=" + this.initialized + "]";
    }
}

