/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.util;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.compass.core.util.Parameter;

public class ChainedFilter
extends Filter {
    private static final long serialVersionUID = 9048275274970647058L;
    public static ChainedFilterType DEFAULT = ChainedFilterType.OR;
    private Filter[] chain = null;
    private ChainedFilterType[] logicArray;
    private ChainedFilterType logic = null;

    public ChainedFilter(Filter[] chain) {
        this.chain = chain;
    }

    public ChainedFilter(Filter[] chain, ChainedFilterType[] logicArray) {
        this.chain = chain;
        this.logicArray = logicArray;
    }

    public ChainedFilter(Filter[] chain, ChainedFilterType logic) {
        this.chain = chain;
        this.logic = logic;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        if (this.logic != null) {
            return this.bits(reader, this.logic);
        }
        if (this.logicArray != null) {
            return this.bits(reader, this.logicArray);
        }
        return this.bits(reader, DEFAULT);
    }

    private BitSet bits(IndexReader reader, ChainedFilterType logic) throws IOException {
        BitSet result;
        int i = 0;
        if (logic == ChainedFilterType.AND) {
            result = (BitSet)this.chain[i].bits(reader).clone();
            ++i;
        } else {
            result = new BitSet(reader.maxDoc());
        }
        while (i < this.chain.length) {
            this.doChain(result, reader, logic, this.chain[i]);
            ++i;
        }
        return result;
    }

    private BitSet bits(IndexReader reader, ChainedFilterType[] logic) throws IOException {
        BitSet result;
        if (logic.length != this.chain.length) {
            throw new IllegalArgumentException("Invalid number of elements in logic array");
        }
        int i = 0;
        if (logic[0] == ChainedFilterType.AND) {
            result = (BitSet)this.chain[i].bits(reader).clone();
            ++i;
        } else {
            result = new BitSet(reader.maxDoc());
        }
        while (i < this.chain.length) {
            this.doChain(result, reader, logic[i], this.chain[i]);
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChainedFilter: [");
        for (int i = 0; i < this.chain.length; ++i) {
            sb.append(this.chain[i]);
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void doChain(BitSet result, IndexReader reader, ChainedFilterType logic, Filter filter) throws IOException {
        if (logic == ChainedFilterType.OR) {
            result.or(filter.bits(reader));
        } else if (logic == ChainedFilterType.AND) {
            result.and(filter.bits(reader));
        } else if (logic == ChainedFilterType.ANDNOT) {
            result.andNot(filter.bits(reader));
        } else if (logic == ChainedFilterType.XOR) {
            result.xor(filter.bits(reader));
        } else {
            this.doChain(result, reader, DEFAULT, filter);
        }
    }

    public static final class ChainedFilterType
    extends Parameter {
        private static final long serialVersionUID = 1983615628912707296L;
        public static final ChainedFilterType OR = new ChainedFilterType("OR");
        public static final ChainedFilterType AND = new ChainedFilterType("AND");
        public static final ChainedFilterType ANDNOT = new ChainedFilterType("ANDNOT");
        public static final ChainedFilterType XOR = new ChainedFilterType("XOR");

        private ChainedFilterType(String name) {
            super(name);
        }
    }
}

