/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.impl;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HandlerChainsParser {
    private static final String JAVA_EE_NS = "http://java.sun.com/xml/ns/javaee";
    private static final QName QNAME_HANDLER_CHAINS = new QName("http://java.sun.com/xml/ns/javaee", "handler-chains");
    private static final QName QNAME_HANDLER_CHAIN = new QName("http://java.sun.com/xml/ns/javaee", "handler-chain");
    private static JAXBContext context;

    public HandlerChainsType loadHandlerChains(InputStream in) throws Exception {
        Document document = XMLUtils.newDocument(in);
        Element el = document.getDocumentElement();
        if (!JAVA_EE_NS.equals(el.getNamespaceURI()) || !"handler-chains".equals(el.getLocalName())) {
            throw new WebServiceException("Unexpected element {" + el.getNamespaceURI() + "}" + el.getLocalName() + ". Expected " + QNAME_HANDLER_CHAINS + " element");
        }
        HandlerChainsType handlerChains = new HandlerChainsType();
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            el = (Element)node;
            if (!JAVA_EE_NS.equals(el.getNamespaceURI()) || !el.getLocalName().equals("handler-chain")) {
                throw new WebServiceException("Unexpected element {" + el.getNamespaceURI() + "}" + el.getLocalName() + ". Expected " + QNAME_HANDLER_CHAIN + " element");
            }
            handlerChains.getHandlerChain().add(this.processHandlerChainElement(el));
        }
        return handlerChains;
    }

    private HandlerChainType processHandlerChainElement(Element el) throws Exception {
        HandlerChainType handler = new HandlerChainType();
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node cur = node;
            if (!(cur instanceof Element)) continue;
            el = (Element)cur;
            if (!JAVA_EE_NS.equals(el.getNamespaceURI())) {
                throw new WebServiceException();
            }
            String name = el.getLocalName();
            if ("port-name-pattern".equals(name)) {
                handler.setPortNamePattern(this.processPatternElement(el));
                continue;
            }
            if ("service-name-pattern".equals(name)) {
                handler.setServiceNamePattern(this.processPatternElement(el));
                continue;
            }
            if (!"protocol-bindings".equals(name)) continue;
            handler.getProtocolBindings().addAll(this.processProtocolBindingsElement(el));
        }
        return handler;
    }

    private List<String> processProtocolBindingsElement(Element el) {
        String protocolBindingsString = el.getTextContent().trim();
        String[] protocolBindings = protocolBindingsString.split("\\s+");
        return Arrays.asList(protocolBindings);
    }

    private QName processPatternElement(Element el) throws Exception {
        String namePattern = el.getTextContent().trim();
        if ("*".equals(namePattern)) {
            return new QName("*");
        }
        if (!namePattern.contains(":")) {
            return new QName("", namePattern, "");
        }
        String localPart = namePattern.substring(namePattern.indexOf(58) + 1, namePattern.length());
        String pfx = namePattern.substring(0, namePattern.indexOf(58));
        String ns = el.lookupNamespaceURI(pfx);
        if (ns == null) {
            ns = pfx;
        }
        return new QName(ns, localPart, pfx);
    }

    private HandlerType processHandlerElement(Element el) throws Exception {
        JAXBContext ctx = HandlerChainsParser.getContextForHandlerType();
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        HandlerType handler = (HandlerType)unmarshaller.unmarshal((Node)el, HandlerType.class).getValue();
        return handler;
    }

    private static synchronized JAXBContext getContextForHandlerType() throws JAXBException {
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{HandlerType.class});
        }
        return context;
    }
}

