/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.notifier;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.TopicSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageQueue;

public class InstanceNotifierEventReceiver
implements Runnable {
    private static final Log log = LogFactory.getLog(InstanceNotifierEventReceiver.class);
    private InstanceNotifierEventMessageDelegator messageDelegator;
    private InstanceNotifierEventMessageListener messageListener;
    private TopicSubscriber topicSubscriber;
    private boolean terminated;

    public InstanceNotifierEventReceiver() {
        InstanceNotifierEventMessageQueue messageQueue = new InstanceNotifierEventMessageQueue();
        this.messageDelegator = new InstanceNotifierEventMessageDelegator(messageQueue);
        this.messageListener = new InstanceNotifierEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block7: {
            try {
                this.topicSubscriber = new TopicSubscriber("instance-notifier");
                this.topicSubscriber.setMessageListener(this.messageListener);
                Thread subscriberThread = new Thread(this.topicSubscriber);
                subscriberThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message receiver thread started");
                }
                Thread receiverThread = new Thread(this.messageDelegator);
                receiverThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message delegator thread started");
                }
                while (!this.terminated) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"InstanceNotifier receiver failed", (Throwable)e);
            }
        }
    }

    public boolean isSubscribed() {
        return this.topicSubscriber != null && this.topicSubscriber.isSubscribed();
    }

    public void terminate() {
        this.topicSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }
}

