/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.CompleteTopologyEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyMemberFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.util.Util;

public class CompleteTopologyMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(CompleteTopologyMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (CompleteTopologyEvent.class.getName().equals(type)) {
            CompleteTopologyEvent event = (CompleteTopologyEvent)Util.jsonToObject(message, CompleteTopologyEvent.class);
            if (!topology.isInitialized()) {
                if (TopologyServiceFilter.getInstance().isActive()) {
                    for (Service service : event.getTopology().getServices()) {
                        if (TopologyServiceFilter.getInstance().serviceNameIncluded(service.getServiceName())) {
                            topology.addService(service);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Service is excluded: [service] %s", service.getServiceName()));
                    }
                } else {
                    topology.addServices(event.getTopology().getServices());
                }
                if (TopologyClusterFilter.getInstance().isActive()) {
                    for (Service service : topology.getServices()) {
                        ArrayList<Cluster> clustersToRemove = new ArrayList<Cluster>();
                        for (Cluster cluster : service.getClusters()) {
                            if (!TopologyClusterFilter.getInstance().clusterIdExcluded(cluster.getClusterId())) continue;
                            clustersToRemove.add(cluster);
                        }
                        for (Cluster cluster : clustersToRemove) {
                            service.removeCluster(cluster);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("Cluster is excluded: [cluster] %s", cluster.getClusterId()));
                        }
                    }
                }
                if (TopologyMemberFilter.getInstance().isActive()) {
                    for (Service service : topology.getServices()) {
                        for (Cluster cluster : service.getClusters()) {
                            ArrayList<Member> membersToRemove = new ArrayList<Member>();
                            for (Member member : cluster.getMembers()) {
                                if (!TopologyMemberFilter.getInstance().lbClusterIdExcluded(member.getLbClusterId())) continue;
                                membersToRemove.add(member);
                            }
                            for (Member member : membersToRemove) {
                                cluster.removeMember(member);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)String.format("Member is excluded: [member] %s [lb-cluster-id] %s", member.getMemberId(), member.getLbClusterId()));
                            }
                        }
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Topology initialized");
                }
                topology.setInitialized(true);
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        return false;
    }
}

