/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ClusterRemovedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.util.Util;

public class ClusterRemovedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ClusterRemovedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ClusterRemovedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ClusterRemovedEvent event = (ClusterRemovedEvent)Util.jsonToObject(message, ClusterRemovedEvent.class);
            if (TopologyServiceFilter.getInstance().isActive() && TopologyServiceFilter.getInstance().serviceNameExcluded(event.getServiceName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Service is excluded: [service] %s", event.getServiceName()));
                }
                return false;
            }
            if (TopologyClusterFilter.getInstance().isActive() && TopologyClusterFilter.getInstance().clusterIdExcluded(event.getClusterId())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Cluster is excluded: [cluster] %s", event.getClusterId()));
                }
                return false;
            }
            Service service = topology.getService(event.getServiceName());
            if (service == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
                }
                return false;
            }
            if (!service.clusterExists(event.getClusterId())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Cluster does not exist: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
                }
            } else {
                service.removeCluster(event.getClusterId());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Cluster removed from service: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
                }
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }
}

