/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.event;

import java.util.Observable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.listener.EventListener;

public abstract class EventObservable
extends Observable {
    private static final Log log = LogFactory.getLog(EventObservable.class);

    public void addEventListener(EventListener eventListener) {
        this.addObserver(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Removing event listeners: [event-listener] %s", eventListener.getClass().getName()));
        }
        this.deleteObserver(eventListener);
    }

    public void notifyEventListeners(Event event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Notifying event listeners: [event] %s", event.getClass().getName()));
        }
        this.setChanged();
        this.notifyObservers(event);
    }
}

