/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.publish;

import com.google.gson.Gson;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicConnector;
import org.apache.stratos.messaging.publish.MessagePublisher;

public class TopicPublisher
extends MessagePublisher {
    private static final Log log = LogFactory.getLog(TopicPublisher.class);
    private TopicSession topicSession;
    private TopicConnector connector = new TopicConnector();
    private javax.jms.TopicPublisher topicPublisher = null;
    private boolean initialized;

    TopicPublisher(String aTopicName) {
        super(aTopicName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Topic publisher connector created: [topic] %s", this.getName()));
        }
    }

    @Override
    public void publish(Object messageObj, boolean retry) {
        this.publish(messageObj, null, retry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Object messageObj, Properties headers, boolean retry) {
        Class<TopicPublisher> clazz = TopicPublisher.class;
        synchronized (TopicPublisher.class) {
            Gson gson = new Gson();
            String message = gson.toJson(messageObj);
            boolean published = false;
            while (!published) {
                try {
                    this.doPublish(message, headers);
                    published = true;
                }
                catch (Exception e) {
                    this.initialized = false;
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Error while publishing to the topic: " + this.getName()), (Throwable)e);
                    }
                    if (!retry) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Retry disabled for topic " + this.getName()));
                        }
                        throw new RuntimeException(e);
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Will try to re-publish in 60 sec");
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<TopicPublisher> clazz = TopicPublisher.class;
        synchronized (TopicPublisher.class) {
            try {
                if (this.topicPublisher != null) {
                    this.topicPublisher.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Topic publisher closed: [topic] %s", this.getName()));
                    }
                }
                if (this.topicSession != null) {
                    this.topicSession.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Topic publisher session closed: [topic] %s", this.getName()));
                    }
                }
                if (this.connector != null) {
                    this.connector.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Topic publisher connector closed: [topic] %s", this.getName()));
                    }
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPublish(String message, Properties headers) throws Exception, JMSException {
        block16: {
            if (!this.initialized) {
                this.connector.init(this.getName());
                this.initialized = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Topic publisher connector initialized: [topic] %s", this.getName()));
                }
            }
            try {
                this.topicSession = this.createSession(this.connector);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Topic publisher session created: [topic] %s", this.getName()));
                }
                this.topicPublisher = this.createPublisher(this.topicSession);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Topic publisher created: [topic] %s", this.getName()));
                }
                TextMessage textMessage = this.topicSession.createTextMessage(message);
                if (headers != null) {
                    Enumeration<?> e = headers.propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        textMessage.setStringProperty(key, headers.getProperty(key));
                    }
                }
                this.topicPublisher.publish((Message)textMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Message published: [topic] %s [header] %s [body] %s", this.getName(), headers != null ? headers.toString() : "null", message));
                }
                if (this.topicPublisher == null) break block16;
            }
            catch (Throwable throwable) {
                if (this.topicPublisher != null) {
                    this.topicPublisher.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Topic publisher closed: [topic] %s", this.getName()));
                    }
                }
                if (this.topicSession != null) {
                    this.topicSession.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Topic publisher session closed: [topic] %s", this.getName()));
                    }
                }
                throw throwable;
            }
            this.topicPublisher.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Topic publisher closed: [topic] %s", this.getName()));
            }
        }
        if (this.topicSession != null) {
            this.topicSession.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Topic publisher session closed: [topic] %s", this.getName()));
            }
        }
    }

    private TopicSession createSession(TopicConnector topicConnector) throws Exception {
        return topicConnector.newSession();
    }

    private javax.jms.TopicPublisher createPublisher(TopicSession topicSession) throws Exception, JMSException {
        Topic topic = this.connector.getTopic();
        if (topic == null) {
            topic = topicSession.createTopic(this.getName());
        }
        return topicSession.createPublisher(topic);
    }
}

