/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect;

import java.io.File;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.stratos.messaging.util.Util;

public class TopicConnector {
    private TopicConnection topicConnection;
    private String jndiPropFileDir = System.getProperty("jndi.properties.dir");
    private Topic topic;

    public void init(String topicName) throws Exception {
        Properties environment = Util.getProperties(this.jndiPropFileDir + File.separator + "jndi.properties");
        environment.put("org.wso2.carbon.context.RequestBaseContext", "true");
        InitialContext ctx = new InitialContext(environment);
        String connectionFactoryName = environment.get("connectionfactoryName").toString();
        TopicConnectionFactory connFactory = (TopicConnectionFactory)ctx.lookup(connectionFactoryName);
        try {
            this.setTopic((Topic)ctx.lookup(topicName));
        }
        catch (NamingException e) {
            // empty catch block
        }
        this.topicConnection = connFactory.createTopicConnection();
        this.topicConnection.start();
    }

    public TopicSession newSession() throws Exception {
        return this.topicConnection.createTopicSession(false, 1);
    }

    public void close() throws JMSException {
        if (this.topicConnection == null) {
            return;
        }
        this.topicConnection.close();
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }
}

