/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment.service.listeners;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.utils.deployment.service.Axis2ConfigParameterProvider;
import org.wso2.carbon.utils.deployment.service.processors.Axis2ConfigParameterProcessor;
import org.wso2.carbon.utils.deployment.service.processors.AxisObserverProcessor;
import org.wso2.carbon.utils.deployment.service.processors.ConfigurationServiceProcessor;
import org.wso2.carbon.utils.deployment.service.processors.DeployerServiceProcessor;

public class Axis2ConfigServiceListener
implements ServiceListener {
    private static Log log = LogFactory.getLog(Axis2ConfigServiceListener.class);
    private BundleContext bundleContext;
    private Map<String, ConfigurationServiceProcessor> configServiceProcessorMap;

    public Axis2ConfigServiceListener(AxisConfiguration axisConfig, BundleContext context) {
        this.bundleContext = context;
        this.registerConfigServiceProcessors(axisConfig);
        this.processRegisteredAxis2ConfigServices();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference reference = event.getServiceReference();
        this.processRegisteredAxis2ConfigServices(reference, event.getType());
    }

    private void processRegisteredAxis2ConfigServices() {
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences((String)null, "(org.apache.axis2.osgi.config.service=*)");
            if (references != null) {
                for (ServiceReference sr : references) {
                    this.processRegisteredAxis2ConfigServices(sr, 1);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            log.error((Object)"Failed to obtain registerd services. Invalid filter Syntax.", (Throwable)e);
        }
    }

    private void registerConfigServiceProcessors(AxisConfiguration axisConfig) {
        this.configServiceProcessorMap = new HashMap<String, ConfigurationServiceProcessor>();
        this.configServiceProcessorMap.put(Deployer.class.getName(), new DeployerServiceProcessor(axisConfig, this.bundleContext));
        this.configServiceProcessorMap.put(Axis2ConfigParameterProvider.class.getName(), new Axis2ConfigParameterProcessor(axisConfig, this.bundleContext));
        this.configServiceProcessorMap.put(AxisObserver.class.getName(), new AxisObserverProcessor(axisConfig, this.bundleContext));
    }

    private void processRegisteredAxis2ConfigServices(ServiceReference sr, int eventType) {
        ConfigurationServiceProcessor configServiceProcessor;
        String configService = (String)sr.getProperty("org.apache.axis2.osgi.config.service");
        if (this.configServiceProcessorMap != null && (configServiceProcessor = this.configServiceProcessorMap.get(configService)) != null) {
            try {
                configServiceProcessor.processConfigurationService(sr, eventType);
            }
            catch (AxisFault axisFault) {
                String msg = "Failed to process the configuration service :" + configService;
                log.error((Object)msg, (Throwable)axisFault);
            }
        }
    }
}

