/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.statistics.publisher;

import java.util.ArrayList;
import org.apache.stratos.common.statistics.publisher.WSO2CEPStatisticsPublisher;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class WSO2CEPFaultyMemberPublisher
extends WSO2CEPStatisticsPublisher {
    private static final String DATA_STREAM_NAME = "stratos.lb.faulty.members";
    private static final String VERSION = "1.0.0";

    private static StreamDefinition createStreamDefinition() {
        try {
            StreamDefinition streamDefinition = new StreamDefinition(DATA_STREAM_NAME, VERSION);
            streamDefinition.setNickName("lb fault members");
            streamDefinition.setDescription("lb fault members");
            ArrayList<Attribute> payloadData = new ArrayList<Attribute>();
            payloadData.add(new Attribute("cluster_id", AttributeType.STRING));
            payloadData.add(new Attribute("member_id", AttributeType.STRING));
            streamDefinition.setPayloadData(payloadData);
            return streamDefinition;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create stream definition", e);
        }
    }

    public WSO2CEPFaultyMemberPublisher() {
        super(WSO2CEPFaultyMemberPublisher.createStreamDefinition());
    }

    public void publish(String clusterId, String memberId) {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add(clusterId);
        payload.add(memberId);
        super.publish(payload.toArray());
    }
}

