/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.lb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.AgentHolder;
import org.wso2.carbon.databridge.agent.thrift.AsyncDataPublisher;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.internal.utils.AgentServerURL;
import org.wso2.carbon.databridge.agent.thrift.lb.DataPublisherHolder;
import org.wso2.carbon.databridge.agent.thrift.lb.ReceiverStateObserver;
import org.wso2.carbon.databridge.agent.thrift.util.PublishData;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class ReceiverGroup
implements ReceiverStateObserver {
    private static Log log = LogFactory.getLog(ReceiverGroup.class);
    private ArrayList<DataPublisherHolder> dataPublisherCache = new ArrayList();
    private AtomicInteger currentDataPublisherIndex;
    private int maximumDataPublisherIndex;
    private final Integer START_INDEX = 0;
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final LinkedBlockingQueue<PublishData> receiverGroupUnsentEventQueue;
    private boolean isFailOver = false;

    public ReceiverGroup(ArrayList<DataPublisherHolder> properties) {
        for (DataPublisherHolder aHolder : properties) {
            this.dataPublisherCache.add(aHolder);
        }
        this.maximumDataPublisherIndex = properties.size() - 1;
        this.currentDataPublisherIndex = new AtomicInteger(this.START_INDEX);
        this.receiverGroupUnsentEventQueue = new LinkedBlockingQueue(AgentHolder.getOrCreateAgent().getAgentConfiguration().getLoadBalancingDataPublisherBufferedEventSize());
    }

    public ReceiverGroup(ArrayList<DataPublisherHolder> properties, boolean failOver) {
        for (DataPublisherHolder aHolder : properties) {
            this.dataPublisherCache.add(aHolder);
        }
        this.maximumDataPublisherIndex = properties.size() - 1;
        this.isFailOver = failOver;
        this.currentDataPublisherIndex = new AtomicInteger(this.START_INDEX);
        this.receiverGroupUnsentEventQueue = new LinkedBlockingQueue(AgentHolder.getOrCreateAgent().getAgentConfiguration().getLoadBalancingDataPublisherBufferedEventSize());
    }

    protected void createDataPublishers(Agent agent, ConcurrentHashMap<String, String> streamDefnCache) {
        for (DataPublisherHolder aHolder : this.dataPublisherCache) {
            aHolder.setAgent(agent);
            aHolder.generateDataPublisher(streamDefnCache);
            aHolder.getDataPublisher().registerReceiverObserver(this);
        }
        long reconnectionInterval = agent.getAgentConfiguration().getReconnectionInterval();
        this.scheduledExecutorService.scheduleAtFixedRate(new ReconnectionTask(), reconnectionInterval, reconnectionInterval, TimeUnit.SECONDS);
    }

    protected void publish(String streamName, String streamVersion, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        AsyncDataPublisher dataPublisher = this.getDataPublisher();
        if (null != dataPublisher) {
            dataPublisher.publish(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap);
        } else {
            this.receiverGroupUnsentEventQueue.offer(new PublishData(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
        }
    }

    protected void publish(String streamName, String streamVersion, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        AsyncDataPublisher dataPublisher = this.getDataPublisher();
        if (null != dataPublisher) {
            dataPublisher.publish(streamName, streamVersion, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap);
        } else {
            this.receiverGroupUnsentEventQueue.offer(new PublishData(streamName, streamVersion, System.currentTimeMillis(), metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
        }
    }

    protected void publish(Event event) {
        AsyncDataPublisher dataPublisher = this.getDataPublisher();
        if (null != dataPublisher) {
            try {
                dataPublisher.publish(event);
            }
            catch (AgentException e) {
                log.error((Object)"No receiver is reachable, can't publish the event.");
            }
        } else {
            this.receiverGroupUnsentEventQueue.offer(new PublishData(null, null, event));
        }
    }

    protected void publish(String streamName, String streamVersion, Event event) throws AgentException {
        AsyncDataPublisher dataPublisher = this.getDataPublisher();
        if (null != dataPublisher) {
            dataPublisher.publish(streamName, streamVersion, event);
        } else {
            this.receiverGroupUnsentEventQueue.add(new PublishData(streamName, streamVersion, event));
        }
    }

    private AsyncDataPublisher getDataPublisher() {
        int startIndex = -1;
        startIndex = !this.isFailOver ? this.getDataPublisherIndex() : this.START_INDEX.intValue();
        int index = startIndex;
        do {
            DataPublisherHolder publisherHolder;
            if ((publisherHolder = this.dataPublisherCache.get(index)).getConnected().get()) {
                return publisherHolder.getDataPublisher();
            }
            if (++index <= this.maximumDataPublisherIndex) continue;
            index = this.START_INDEX;
        } while (index != startIndex);
        return null;
    }

    private synchronized int getDataPublisherIndex() {
        int index = this.currentDataPublisherIndex.getAndIncrement();
        if (index == this.maximumDataPublisherIndex) {
            this.currentDataPublisherIndex.set(this.START_INDEX);
        }
        return index;
    }

    public void addStreamDefinition(String streamDefn, String streamName, String version) {
        for (int i = this.START_INDEX.intValue(); i <= this.maximumDataPublisherIndex; ++i) {
            DataPublisherHolder holder = this.dataPublisherCache.get(i);
            holder.getDataPublisher().addStreamDefinition(streamDefn, streamName, version);
        }
    }

    public void addStreamDefinition(StreamDefinition streamDefn) {
        for (int i = this.START_INDEX.intValue(); i <= this.maximumDataPublisherIndex; ++i) {
            DataPublisherHolder holder = this.dataPublisherCache.get(i);
            holder.getDataPublisher().addStreamDefinition(streamDefn);
        }
    }

    private AsyncDataPublisher setConnectionStatus(String receiverUrl, String username, String password, boolean status) {
        for (int i = this.START_INDEX.intValue(); i <= this.maximumDataPublisherIndex; ++i) {
            DataPublisherHolder holder = this.dataPublisherCache.get(i);
            if (!holder.getReceiverUrl().equalsIgnoreCase(receiverUrl) || !holder.getUsername().equalsIgnoreCase(username) || !holder.getPassword().equalsIgnoreCase(password)) continue;
            holder.setConnected(status);
            return holder.getDataPublisher();
        }
        return null;
    }

    @Override
    public void notifyConnectionFailure(String receiverUrl, String username, String password) {
        this.setConnectionStatus(receiverUrl, username, password, false);
    }

    @Override
    public void resendEvents(LinkedBlockingQueue<Event> events) {
        if (null != events) {
            Event event;
            if (events.size() > 0) {
                log.info((Object)"Resending the failed events....");
            }
            while (null != (event = events.poll())) {
                this.publish(event);
            }
        }
    }

    @Override
    public void resendPublishedData(LinkedBlockingQueue<PublishData> publishDatas) {
        if (null != publishDatas) {
            PublishData data;
            if (publishDatas.size() > 0) {
                log.info((Object)"Resending the failed published data...");
            }
            while (null != (data = publishDatas.poll())) {
                try {
                    if (data.getStreamName() == null) {
                        this.publish(data.getEvent());
                        continue;
                    }
                    this.publish(data.getStreamName(), data.getStreamVersion(), data.getEvent());
                }
                catch (AgentException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    @Override
    public void notifyConnectionSuccess(String receiverUrl, String username, String password) {
        this.setConnectionStatus(receiverUrl, username, password, true);
        if (this.receiverGroupUnsentEventQueue.size() > 0) {
            this.resendPublishedData(this.receiverGroupUnsentEventQueue);
        }
    }

    protected void stop() {
        for (DataPublisherHolder aHolder : this.dataPublisherCache) {
            if (null == aHolder.getDataPublisher()) continue;
            aHolder.getDataPublisher().stop();
        }
    }

    private class ReconnectionTask
    implements Runnable {
        private ReconnectionTask() {
        }

        @Override
        public void run() {
            boolean isOneReceiverConnected = false;
            for (int i = ReceiverGroup.this.START_INDEX.intValue(); i <= ReceiverGroup.this.maximumDataPublisherIndex; ++i) {
                DataPublisherHolder dataPublisherHolder = (DataPublisherHolder)ReceiverGroup.this.dataPublisherCache.get(i);
                if (!dataPublisherHolder.getConnected().get()) {
                    dataPublisherHolder.getDataPublisher().reconnect();
                } else {
                    AgentServerURL serverURL = null;
                    try {
                        serverURL = new AgentServerURL(dataPublisherHolder.getReceiverUrl());
                    }
                    catch (MalformedURLException ignored) {
                        // empty catch block
                    }
                    if (null != serverURL && !this.isServerExists(serverURL.getHost(), serverURL.getPort())) {
                        dataPublisherHolder.setConnected(false);
                    }
                }
                if (!dataPublisherHolder.getConnected().get()) continue;
                isOneReceiverConnected = true;
            }
            if (!isOneReceiverConnected) {
                log.error((Object)"No receiver is reachable at reconnection, can't publish the events");
            }
        }

        private boolean isServerExists(String ip, int port) {
            try {
                new Socket(ip, port);
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

