/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.ArrayList;
import org.wso2.carbon.user.api.Property;

public class ReadOnlyLDAPUserStoreConstants {
    public static final ArrayList<Property> ROLDAP_USERSTORE_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> OPTIONAL_ROLDAP_USERSTORE_PROPERTIES = new ArrayList();

    private static void setMandatoryProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        ROLDAP_USERSTORE_PROPERTIES.add(property);
    }

    private static void setProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.add(property);
    }

    static {
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("ConnectionName", "uid=,ou=", "This should be the DN (Distinguish Name) of the admin user in LDAP");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("ConnectionURL", "ldap://", "Connection URL for the user store");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("ConnectionPassword", "", "Password of the admin user");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserSearchBase", "ou=system", "DN of the context under which user entries are stored in LDAP");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("Disabled", "false", "Whether user store is disabled");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserNameListFilter", "(objectClass=person)", "Filtering criteria for listing all the user entries in LDAP");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserNameAttribute", "uid", "Attribute used for uniquely identifying a user entry. Users can be authenticated using their email address, uid and etc");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("UserNameSearchFilter", "(&amp;(objectClass=person)(uid=?))", "Filtering criteria for searching a particular user entry");
        ReadOnlyLDAPUserStoreConstants.setMandatoryProperty("ReadOnly", "true", "Indicates whether the user store is in read only mode or not");
        ReadOnlyLDAPUserStoreConstants.setProperty("MaxUserNameListLength", "100", "Maximum number of users retrieved at once");
        ReadOnlyLDAPUserStoreConstants.setProperty("MaxRoleNameListLength", "100", "Maximum number of roles retrieved at once");
        ReadOnlyLDAPUserStoreConstants.setProperty("UserRolesCacheEnabled", "true", "This is to indicate whether to cache the role list of a user");
        ReadOnlyLDAPUserStoreConstants.setProperty("SCIMEnabled", "false", "Whether SCIM is enabled for the user store");
        Property readLDAPGroups = new Property("ReadGroups", "false", "Specifies whether groups should be read from LDAP", null);
        Property groupSearchBase = new Property("GroupSearchBase", "ou=system", "DN of the context under which user entries are stored in LDAP", null);
        Property groupNameListFilter = new Property("GroupNameListFilter", "(objectClass=groupOfNames)", "Filtering criteria for listing all the group entries in LDAP", null);
        Property groupNameAttribute = new Property("GroupNameAttribute", "cn", "Attribute used for uniquely identifying a user entry", null);
        Property membershipAttribute = new Property("MembershipAttribute", "member", "Attribute used to define members of LDAP groups", null);
        readLDAPGroups.setChildProperties(new Property[]{groupSearchBase, groupNameListFilter, groupNameAttribute, membershipAttribute});
        OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.add(readLDAPGroups);
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupSearchBase", "ou=system", "DN of the context under which user entries are stored in LDAP");
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupNameListFilter", "(objectClass=groupOfNames)", "Filtering criteria for listing all the group entries in LDAP");
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupNameSearchFilter", "(&amp;(objectClass=groupOfNames)(cn=?))", "Filtering criteria for searching a particular group entry");
        ReadOnlyLDAPUserStoreConstants.setProperty("GroupNameAttribute", "cn", "Attribute used for uniquely identifying a user entry");
        ReadOnlyLDAPUserStoreConstants.setProperty("MembershipAttribute", "member", "Attribute used to define members of LDAP groups");
        ReadOnlyLDAPUserStoreConstants.setProperty("PasswordHashMethod", "PLAIN_TEXT", "Password Hash method to use when storing user entries");
        ReadOnlyLDAPUserStoreConstants.setProperty("ReplaceEscapeCharactersAtUserLogin", "true", "Whether replace escape character when user login");
    }
}

