/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.proxy;

import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.topic.PublishOperation;
import com.hazelcast.topic.TopicService;
import com.hazelcast.topic.proxy.TopicProxy;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.Future;

public class TotalOrderedTopicProxy
extends TopicProxy {
    private final int partitionId;

    public TotalOrderedTopicProxy(String name, NodeEngine nodeEngine, TopicService service) {
        super(name, nodeEngine, service);
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(name);
    }

    @Override
    public void publish(Object message) {
        try {
            NodeEngine nodeEngine = this.getNodeEngine();
            PublishOperation operation = new PublishOperation(this.getName(), nodeEngine.toData(message));
            Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:topicService", (Operation)operation, this.partitionId).build();
            Future f = inv.invoke();
            f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }
}

