/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MapEntrySet
implements IdentifiedDataSerializable {
    private final Set<Map.Entry<Data, Data>> entrySet;

    public MapEntrySet() {
        this.entrySet = new HashSet<Map.Entry<Data, Data>>();
    }

    public MapEntrySet(Set<Map.Entry<Data, Data>> entrySet) {
        this.entrySet = entrySet;
    }

    public Set<Map.Entry<Data, Data>> getEntrySet() {
        return this.entrySet;
    }

    public void add(Map.Entry<Data, Data> entry) {
        this.entrySet.add(entry);
    }

    public void add(Data key, Data value) {
        this.entrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int size = this.entrySet.size();
        out.writeInt(size);
        for (Map.Entry<Data, Data> o : this.entrySet) {
            o.getKey().writeData(out);
            o.getValue().writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            AbstractMap.SimpleImmutableEntry<Data, Data> entry = new AbstractMap.SimpleImmutableEntry<Data, Data>(IOUtil.readData(in), IOUtil.readData(in));
            this.entrySet.add(entry);
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 10;
    }
}

