/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.writers;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/rdf+xml", "text/turtle", "text/n3", "text/plain", "application/turtle"})
@Component
@Service(value={Object.class})
@Property(name="javax.ws.rs", boolValue={true})
public class JenaModelWriter
implements MessageBodyWriter<Model> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ByteArrayOutputStream stream = null;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Model.class.isAssignableFrom(type);
    }

    public long getSize(Model t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        this.log.debug("Called size of item");
        this.stream = this.toStream(t, mediaType.toString());
        this.log.debug("Returning {} bytes", (Object)this.stream.size());
        return Integer.valueOf(this.stream.toByteArray().length).longValue();
    }

    public ByteArrayOutputStream toStream(Model t, String mediaType) {
        this.log.debug("Serializing model to {}. Statements are {}", (Object)mediaType, (Object)t.listStatements().toSet().size());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (mediaType.equals("application/rdf+xml")) {
            t.write((OutputStream)stream);
        } else if (mediaType.equals("application/turtle")) {
            RDFWriter writer = t.getWriter("TURTLE");
            this.log.debug("Writer for TURTLE: {}", (Object)writer);
            writer.write(t, (OutputStream)stream, null);
        } else if (mediaType.equals("text/turtle")) {
            t.write((OutputStream)stream, "TURTLE");
        } else if (mediaType.equals("text/plain")) {
            t.write((OutputStream)stream, "TURTLE");
        } else if (mediaType.equals("text/n3")) {
            t.write((OutputStream)stream, "N3");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Written {} bytes to stream", (Object)stream.toByteArray().length);
        }
        return stream;
    }

    public void writeTo(Model t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (this.stream == null) {
            this.toStream(t, mediaType.toString()).writeTo(entityStream);
        } else {
            this.stream.writeTo(entityStream);
            this.stream = null;
        }
    }
}

