/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.resources;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.jaxrs.utils.form.FormFile;
import org.apache.clerezza.jaxrs.utils.form.MultiPartBody;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.commons.jobs.api.Job;
import org.apache.stanbol.commons.jobs.api.JobManager;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.viewable.Viewable;
import org.apache.stanbol.ontologymanager.servicesapi.scope.ScopeManager;
import org.apache.stanbol.ontologymanager.servicesapi.session.SessionManager;
import org.apache.stanbol.reasoners.jena.JenaReasoningService;
import org.apache.stanbol.reasoners.owlapi.OWLApiReasoningService;
import org.apache.stanbol.reasoners.servicesapi.ReasoningService;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputManager;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServicesManager;
import org.apache.stanbol.reasoners.servicesapi.UnboundReasoningServiceException;
import org.apache.stanbol.reasoners.servicesapi.annotations.Documentation;
import org.apache.stanbol.reasoners.web.input.impl.SimpleInputManager;
import org.apache.stanbol.reasoners.web.input.provider.impl.ByteArrayInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.OntologyManagerInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.RecipeInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.UrlInputProvider;
import org.apache.stanbol.reasoners.web.resources.ReasoningResult;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceExecutor;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceResult;
import org.apache.stanbol.reasoners.web.utils.ResponseTaskBuilder;
import org.apache.stanbol.rules.base.api.RuleAdapterManager;
import org.apache.stanbol.rules.base.api.RuleStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/reasoners/{service}/{task: [^/]+}{job: (/job)?}")
@Component
@Service(value={Object.class})
@Property(name="javax.ws.rs", boolValue={true})
public class ReasoningServiceTaskResource
extends BaseStanbolResource {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ReasoningService<?, ?, ?> service;
    private Map<String, List<String>> parameters;
    private FormFile file = null;
    @Reference
    protected TcManager tcManager;
    @Reference
    protected ScopeManager onm;
    @Reference
    protected SessionManager sessionManager;
    @Reference
    protected RuleStore ruleStore;
    @Reference
    protected RuleAdapterManager adapterManager;
    private boolean job = false;
    private String jobLocation = "";
    @Reference
    protected ReasoningServicesManager reasoningServicesManager;
    @Reference
    protected JobManager jobManager;
    @Context
    private UriInfo uriInfo;
    @Context
    private Form form = null;
    @Context
    private HttpHeaders headers;
    private String taskID;

    public void prepare(String serviceID, String taskIDstr, String jobFlag) {
        this.taskID = taskIDstr;
        this.log.debug("Called service {} to perform task {}", (Object)serviceID, (Object)this.taskID);
        this.parameters = this.prepareParameters();
        try {
            this.service = this.getService(serviceID);
        }
        catch (UnboundReasoningServiceException e) {
            this.log.error("Service not found: {}", (Object)serviceID);
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        this.log.debug("Service retrieved");
        if (!this.service.supportsTask(this.taskID) && !this.taskID.equals(ReasoningServiceExecutor.TASK_CHECK)) {
            this.log.error("Unsupported task (not found): {}", (Object)this.taskID);
            throw new WebApplicationException((Throwable)new Exception("Unsupported task (not found): " + this.taskID), Response.Status.NOT_FOUND);
        }
        if (!jobFlag.equals("")) {
            this.log.debug("Job param is {}", (Object)this.job);
            if (jobFlag.equals("/job")) {
                this.log.debug("Ask for background job");
                this.job = true;
            } else {
                this.log.error("Malformed request");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        if (!(this.getCurrentService() instanceof JenaReasoningService) && !(this.getCurrentService() instanceof OWLApiReasoningService)) {
            this.log.error("This implementation of ReasoningService is not supported: {}", this.getCurrentService().getClass());
            throw new WebApplicationException((Throwable)new Exception("This implementation of ReasoningService is not supported: " + this.getCurrentService().getClass()), Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.log.debug("Implementation is supported");
    }

    private Map<String, List<String>> prepareParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        this.log.debug("Preparing parameters...");
        MultivaluedMap queryParameters = this.uriInfo.getQueryParameters();
        this.log.debug("... {} query parameters found", (Object)queryParameters.size());
        for (Map.Entry e : queryParameters.entrySet()) {
            String k = (String)e.getKey();
            this.log.debug(" param: {} ", (Object)k);
            ArrayList<String> v = new ArrayList<String>();
            for (String s : (List)e.getValue()) {
                try {
                    s = URLDecoder.decode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                this.log.debug("   value {}", v);
                v.add(s);
            }
            parameters.put(k, v);
        }
        if (this.form != null) {
            MultivaluedMap formParameters = this.form.asMap();
            this.log.debug("... {} form urlencoded parameters found", (Object)formParameters.size());
            for (Map.Entry e : formParameters.entrySet()) {
                parameters.put((String)e.getKey(), (List<String>)e.getValue());
            }
        }
        this.log.debug("Parameters prepared");
        return parameters;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "text/plain", "application/rdf+xml", "text/turtle", "text/turtle", "text/n3"})
    public Response post(@PathParam(value="service") String serviceID, @PathParam(value="task") String taskID, @PathParam(value="job") String jobFlg) {
        this.prepare(serviceID, taskID, jobFlg);
        return this.processRequest();
    }

    private Response processRequest() {
        if (this.job) {
            this.log.trace("Processing in background");
            return this.processBackgroundRequest();
        }
        this.log.trace("Processing in foreground");
        return this.processRealTimeRequest();
    }

    @GET
    @Produces(value={"text/html", "text/plain", "application/rdf+xml", "text/turtle", "text/turtle", "text/n3"})
    public Response get(@QueryParam(value="target") String targetGraphID, @PathParam(value="service") String serviceID, @PathParam(value="task") String taskID, @PathParam(value="job") String jobFlg) {
        this.log.debug("Called GET serviceID {} taskID {}", (Object)serviceID, (Object)taskID);
        this.prepare(serviceID, taskID, jobFlg);
        this.log.debug("Called GET with parameters: {} ", (Object[])this.parameters.keySet().toArray(new String[this.parameters.keySet().size()]));
        return this.processRequest();
    }

    private Response processBackgroundRequest() {
        if (this.parameters.isEmpty()) {
            this.log.error("Cannot start job without input parameters... sending BAD REQUEST");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String target = this.getTarget();
        ReasoningServiceInputManager imngr = this.prepareInput();
        ReasoningServiceExecutor executor = new ReasoningServiceExecutor(this.tcManager, imngr, this.getCurrentService(), this.getCurrentTask(), target, this.parameters);
        String jid = this.getJobManager().execute((Job)executor);
        URI location = URI.create(this.getPublicBaseUri() + "jobs/" + jid);
        this.jobLocation = location.toString();
        Viewable view = new Viewable("created", (Object)this);
        return Response.created((URI)location).entity((Object)view).build();
    }

    private Response processRealTimeRequest() {
        if (this.parameters.isEmpty() && this.file == null) {
            this.log.debug("no parameters no input file, show default index page");
            Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            return rb.build();
        }
        try {
            String target = this.getTarget();
            ReasoningServiceInputManager imngr = this.prepareInput();
            ReasoningServiceExecutor executor = new ReasoningServiceExecutor(this.tcManager, imngr, this.getCurrentService(), this.getCurrentTask(), target, this.parameters);
            Object result = executor.call();
            return new ResponseTaskBuilder(new ReasoningTaskResult(this.uriInfo, this.headers)).build((ReasoningServiceResult<? extends Object>)result);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getTarget() {
        String target = null;
        if (this.parameters.get("target") != null) {
            if (!this.parameters.get("target").isEmpty()) {
                target = this.parameters.get("target").iterator().next();
                if (target.equals("")) {
                    this.log.error("Parameter 'target' must have a value!");
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            } else {
                this.log.error("Parameter 'target' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        return target;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html", "text/plain", "application/rdf+xml", "text/turtle", "text/turtle", "text/n3"})
    public Response post(MultiPartBody data, @PathParam(value="service") String serviceID, @PathParam(value="task") String taskID, @PathParam(value="job") String jobFlg) {
        this.prepare(serviceID, taskID, jobFlg);
        this.log.debug("Called POST post(MultiPartBody data, ...)");
        if (data.getFormFileParameterValues("file").length > 0) {
            this.file = data.getFormFileParameterValues("file")[0];
        } else {
            this.log.debug("No files in multipart body");
        }
        for (String p : data.getTextParameterNames()) {
            this.parameters.put(p, Arrays.asList(data.getTextParameterValues(p)));
        }
        this.log.debug(" parameters: {}", this.parameters);
        this.log.debug(" file: {}", (Object)this.file);
        return this.processRequest();
    }

    private ReasoningServiceInputManager prepareInput() {
        SimpleInputManager inmgr = new SimpleInputManager();
        String scope = null;
        String session = null;
        if (this.file != null) {
            inmgr.addInputProvider(new ByteArrayInputProvider(this.file.getContent()));
        }
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            if (entry.getKey().equals("url")) {
                if (!entry.getValue().isEmpty()) {
                    inmgr.addInputProvider(new UrlInputProvider(entry.getValue().iterator().next()));
                    this.parameters.remove("url");
                    continue;
                }
                this.log.error("Parameter 'url' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("scope")) {
                if (!entry.getValue().isEmpty()) {
                    scope = entry.getValue().iterator().next();
                    continue;
                }
                this.log.error("Parameter 'scope' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("session")) {
                if (!entry.getValue().isEmpty()) {
                    session = entry.getValue().iterator().next();
                    continue;
                }
                this.log.error("Parameter 'session' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (!entry.getKey().equals("recipe")) continue;
            if (!entry.getValue().isEmpty()) {
                inmgr.addInputProvider(new RecipeInputProvider(this.ruleStore, this.adapterManager, entry.getValue().iterator().next()));
                this.parameters.remove("url");
                continue;
            }
            this.log.error("Parameter 'recipe' must have a value!");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (scope != null) {
            inmgr.addInputProvider(new OntologyManagerInputProvider(this.onm, this.sessionManager, scope, session));
            this.parameters.remove("scope");
            this.parameters.remove("session");
        }
        return inmgr;
    }

    public String getCurrentPath() {
        return this.uriInfo.getPath().replaceAll("[\\/]*$", "");
    }

    public ReasoningService<?, ?, ?> getCurrentService() {
        return this.service;
    }

    public String getCurrentTask() {
        return this.taskID;
    }

    public String getJobLocation() {
        return this.jobLocation;
    }

    public List<String> getSupportedTasks() {
        ArrayList<String> supported = new ArrayList<String>();
        supported.add(ReasoningServiceExecutor.TASK_CHECK);
        supported.addAll(this.getCurrentService().getSupportedTasks());
        return supported;
    }

    private ReasoningService<?, ?, ?> getService(String servicePath) throws UnboundReasoningServiceException {
        return this.getServicesManager().get(servicePath);
    }

    private ReasoningServicesManager getServicesManager() {
        this.log.debug("(getServicesManager()) ");
        return this.reasoningServicesManager;
    }

    public Set<ReasoningService<?, ?, ?>> getActiveServices() {
        this.log.debug("(getActiveServices()) There are {} reasoning services", (Object)this.getServicesManager().size());
        return this.getServicesManager().asUnmodifiableSet();
    }

    private JobManager getJobManager() {
        this.log.debug("(getJobManager()) ");
        return this.jobManager;
    }

    public Map<String, String> getServiceDescription() {
        return this.getServiceDescription(this.service);
    }

    public Map<String, String> getServiceDescription(ReasoningService<?, ?, ?> service) {
        String description;
        String name;
        Class<?> serviceC = service.getClass();
        try {
            name = serviceC.getAnnotation(Documentation.class).name();
        }
        catch (NullPointerException e) {
            this.log.warn("The service {} is not documented: missing name", serviceC);
            name = "";
        }
        try {
            description = serviceC.getAnnotation(Documentation.class).description();
        }
        catch (NullPointerException e) {
            this.log.warn("The service {} is not documented: missing description", serviceC);
            description = "";
        }
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("name", name);
        serviceProperties.put("description", description);
        serviceProperties.put("path", service.getPath());
        return serviceProperties;
    }

    protected void bindTcManager(TcManager tcManager) {
        this.tcManager = tcManager;
    }

    protected void unbindTcManager(TcManager tcManager) {
        if (this.tcManager == tcManager) {
            this.tcManager = null;
        }
    }

    protected void bindOnm(ScopeManager scopeManager) {
        this.onm = scopeManager;
    }

    protected void unbindOnm(ScopeManager scopeManager) {
        if (this.onm == scopeManager) {
            this.onm = null;
        }
    }

    protected void bindSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected void unbindSessionManager(SessionManager sessionManager) {
        if (this.sessionManager == sessionManager) {
            this.sessionManager = null;
        }
    }

    protected void bindRuleStore(RuleStore ruleStore) {
        this.ruleStore = ruleStore;
    }

    protected void unbindRuleStore(RuleStore ruleStore) {
        if (this.ruleStore == ruleStore) {
            this.ruleStore = null;
        }
    }

    protected void bindAdapterManager(RuleAdapterManager ruleAdapterManager) {
        this.adapterManager = ruleAdapterManager;
    }

    protected void unbindAdapterManager(RuleAdapterManager ruleAdapterManager) {
        if (this.adapterManager == ruleAdapterManager) {
            this.adapterManager = null;
        }
    }

    protected void bindReasoningServicesManager(ReasoningServicesManager reasoningServicesManager) {
        this.reasoningServicesManager = reasoningServicesManager;
    }

    protected void unbindReasoningServicesManager(ReasoningServicesManager reasoningServicesManager) {
        if (this.reasoningServicesManager == reasoningServicesManager) {
            this.reasoningServicesManager = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    public class ReasoningTaskResult
    extends BaseStanbolResource.ResultData
    implements ReasoningResult {
        private Object result;
        private UriInfo uriInfo;
        private HttpHeaders headers;

        public ReasoningTaskResult(UriInfo uriInfo, HttpHeaders headers) {
            super((BaseStanbolResource)ReasoningServiceTaskResource.this);
            this.headers = headers;
            this.uriInfo = uriInfo;
        }

        @Override
        public void setResult(Object result) {
            this.result = result;
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public UriInfo getUriInfo() {
            return this.uriInfo;
        }
    }
}

