/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.input.provider.impl;

import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.ReasoningProvider;
import org.apache.stanbol.rules.base.api.Adaptable;
import org.apache.stanbol.rules.base.api.NoSuchRecipeException;
import org.apache.stanbol.rules.base.api.Recipe;
import org.apache.stanbol.rules.base.api.RecipeConstructionException;
import org.apache.stanbol.rules.base.api.RuleAdapter;
import org.apache.stanbol.rules.base.api.RuleAdapterManager;
import org.apache.stanbol.rules.base.api.RuleAtomCallExeption;
import org.apache.stanbol.rules.base.api.RuleStore;
import org.apache.stanbol.rules.base.api.UnavailableRuleObjectException;
import org.apache.stanbol.rules.base.api.UnsupportedTypeForExportException;
import org.semanticweb.owlapi.model.SWRLRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeInputProvider
implements ReasoningServiceInputProvider {
    private final Logger log = LoggerFactory.getLogger(RecipeInputProvider.class);
    private RuleStore store;
    private RuleAdapterManager adapterManager;
    private String recipeId;

    public RecipeInputProvider(RuleStore store, RuleAdapterManager adapterManager, String recipeId) {
        this.store = store;
        this.adapterManager = adapterManager;
        this.recipeId = recipeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Iterator<T> getInput(Class<T> type) throws IOException {
        ReasoningProvider reasoningProvider = null;
        if (type.isAssignableFrom(SWRLRule.class)) {
            reasoningProvider = ReasoningProvider.OWL2;
        } else if (type.isAssignableFrom(Rule.class)) {
            reasoningProvider = ReasoningProvider.Jena;
        } else {
            this.log.error("Cannot adapt to this type {}", (Object)type.getCanonicalName());
            throw new UnsupportedOperationException("Cannot adapt to " + type.getCanonicalName());
        }
        switch (reasoningProvider) {
            case OWL2: {
                List rules = null;
                if (this.recipeId != null) {
                    long start = System.currentTimeMillis();
                    this.log.info("[start] Prepare rules for OWLApi ");
                    rules = new ArrayList();
                    try {
                        Recipe recipe = null;
                        RuleStore ruleStore = this.store;
                        synchronized (ruleStore) {
                            try {
                                recipe = this.store.getRecipe(new IRI(this.recipeId));
                            }
                            catch (RecipeConstructionException e) {
                                this.log.error("An error occurred while generating the recipe.", (Throwable)e);
                            }
                        }
                        this.log.debug("Recipe is: {}", (Object)recipe);
                        try {
                            RuleAdapter adapter = this.adapterManager.getAdapter((Adaptable)recipe, SWRLRule.class);
                            rules = (List)adapter.adaptTo((Adaptable)recipe, SWRLRule.class);
                        }
                        catch (UnavailableRuleObjectException e) {
                            this.log.error(e.getMessage(), (Throwable)e);
                        }
                        catch (RuleAtomCallExeption e) {
                            this.log.error(e.getMessage(), (Throwable)e);
                        }
                        catch (UnsupportedTypeForExportException e) {
                            this.log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (NoSuchRecipeException e) {
                        this.log.error("Recipe {} does not exists", (Object)this.recipeId);
                        throw new IOException(e);
                    }
                    long end = System.currentTimeMillis();
                    this.log.info("[end] Prepared {} rules for OWLApi in {} ms.", (Object)rules.size(), (Object)(end - start));
                }
                if (rules == null) {
                    this.log.error("No rules have been loaded");
                    throw new IOException("No rules loaded");
                }
                final Iterator iterator = Collections.unmodifiableList(rules).iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        RecipeInputProvider.this.log.error("Cannot remove items from this iterator. This may be cused by an error in the program");
                        throw new UnsupportedOperationException("Cannot remove items from this iterator");
                    }
                };
            }
            case Jena: {
                List jenaRules = null;
                if (this.recipeId != null) {
                    long start = System.currentTimeMillis();
                    this.log.info("[start] Prepare rules for Jena ");
                    try {
                        Recipe recipe = null;
                        RuleStore ruleStore = this.store;
                        synchronized (ruleStore) {
                            try {
                                recipe = this.store.getRecipe(new IRI(this.recipeId));
                            }
                            catch (RecipeConstructionException e) {
                                this.log.error("An error occurred while generating the recipe.", (Throwable)e);
                            }
                        }
                        if (recipe != null) {
                            this.log.debug("Recipe is: {}", (Object)recipe);
                            try {
                                RuleAdapter adapter = this.adapterManager.getAdapter((Adaptable)recipe, Rule.class);
                                jenaRules = (List)adapter.adaptTo((Adaptable)recipe, Rule.class);
                            }
                            catch (UnavailableRuleObjectException e) {
                                this.log.error(e.getMessage(), (Throwable)e);
                            }
                            catch (RuleAtomCallExeption e) {
                                this.log.error(e.getMessage(), (Throwable)e);
                            }
                            catch (UnsupportedTypeForExportException e) {
                                this.log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    catch (NoSuchRecipeException e) {
                        this.log.error("Recipe {} does not exists", (Object)this.recipeId);
                        throw new IOException(e);
                    }
                    long end = System.currentTimeMillis();
                    this.log.info("[end] Prepared {} rules for Jena in {} ms.", (Object)jenaRules.size(), (Object)(end - start));
                }
                if (jenaRules == null) {
                    this.log.error("No rules have been loaded");
                    throw new IOException("No rules loaded");
                }
                final Iterator jRiterator = Collections.unmodifiableList(jenaRules).iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return jRiterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return jRiterator.next();
                    }

                    @Override
                    public void remove() {
                        RecipeInputProvider.this.log.error("Cannot remove items from this iterator. This may be cused by an error in the program");
                        throw new UnsupportedOperationException("Cannot remove items from this iterator");
                    }
                };
            }
        }
        return null;
    }

    public <T> boolean adaptTo(Class<T> type) {
        if (type.isAssignableFrom(SWRLRule.class)) {
            return true;
        }
        return type.isAssignableFrom(Rule.class);
    }
}

