/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.ontologymanager.servicesapi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntologyNetworkConfigurationUtils {
    private static OWLDataFactory _df = OWLManager.getOWLDataFactory();
    private static final String[] EMPTY_IRI_ARRAY = new String[0];
    private static final OWLClass cScope = _df.getOWLClass(IRI.create((String)"http://stanbol.apache.org/ontology/meta/onm.owl#Scope"));
    private static final OWLClass cLibrary = _df.getOWLClass(IRI.create((String)"http://www.ontologydesignpatterns.org/cpont/codo/coddata.owl#OntologyLibrary"));
    private static final OWLDataProperty activateOnStart = _df.getOWLDataProperty(IRI.create((String)"http://stanbol.apache.org/ontology/meta/onm.owl#activateOnStart"));
    private static final OWLObjectProperty usesCoreOntology = _df.getOWLObjectProperty(IRI.create((String)"http://stanbol.apache.org/ontology/meta/onm.owl#usesCoreOntology"));
    private static final OWLObjectProperty usesCoreLibrary = _df.getOWLObjectProperty(IRI.create((String)"http://stanbol.apache.org/ontology/meta/onm.owl#usesCoreLibrary"));
    private static final OWLObjectProperty usesCustomOntology = _df.getOWLObjectProperty(IRI.create((String)"http://stanbol.apache.org/ontology/meta/onm.owl#usesCustomOntology"));
    private static final OWLObjectProperty usesCustomLibrary = _df.getOWLObjectProperty(IRI.create((String)"http://stanbol.apache.org/ontology/meta/onm.owl#usesCustomLibrary"));
    private static final OWLObjectProperty libraryHasOntology = _df.getOWLObjectProperty(IRI.create((String)"http://stanbol.apache.org/ontology/meta/onm.owl#hasOntology"));

    public static String[] getScopesToActivate(OWLOntology config) {
        Set scopes = cScope.getIndividuals(config);
        ArrayList<String> result = new ArrayList<String>();
        boolean doActivate = false;
        for (OWLIndividual iScope : scopes) {
            Set activate = iScope.getDataPropertyValues((OWLDataPropertyExpression)activateOnStart, config);
            Iterator it = activate.iterator();
            while (it.hasNext() && !doActivate) {
                OWLLiteral l = (OWLLiteral)it.next();
                doActivate |= Boolean.parseBoolean(l.getLiteral());
            }
            if (!iScope.isNamed() || !doActivate) continue;
            result.add(((OWLNamedIndividual)iScope).getIRI().toString());
        }
        return result.toArray(EMPTY_IRI_ARRAY);
    }

    public static String[] getScopes(OWLOntology config) {
        Set scopes = cScope.getIndividuals(config);
        ArrayList<String> result = new ArrayList<String>();
        for (OWLIndividual iScope : scopes) {
            for (OWLClassExpression sce : iScope.getTypes(config)) {
                if (!sce.containsConjunct((OWLClassExpression)cScope) || !iScope.isNamed()) continue;
                result.add(((OWLNamedIndividual)iScope).getIRI().toString());
            }
        }
        return result.toArray(EMPTY_IRI_ARRAY);
    }

    private static String[] getScopeObjectPropertyValues(OWLOntology ontology, String individualIRI, OWLObjectProperty op) {
        Set scopes = cScope.getIndividuals(ontology);
        ArrayList<String> result = new ArrayList<String>();
        OWLIndividual iiScope = null;
        for (OWLIndividual ind : scopes) {
            if (ind.isAnonymous() || !((OWLNamedIndividual)ind).getIRI().toString().equals(individualIRI)) continue;
            iiScope = ind;
            break;
        }
        if (iiScope != null) {
            // empty if block
        }
        for (OWLIndividual iScope : scopes) {
            if (!iScope.isNamed() || !((OWLNamedIndividual)iScope).getIRI().toString().equals(individualIRI)) continue;
            Set values = iScope.getObjectPropertyValues((OWLObjectPropertyExpression)op, ontology);
            for (OWLIndividual i : values) {
                if (!i.isNamed()) continue;
                result.add(((OWLNamedIndividual)i).getIRI().toString());
            }
        }
        return result.toArray(EMPTY_IRI_ARRAY);
    }

    private static String[] getLibraryObjectPropertyValues(OWLOntology ontology, String individualIRI, OWLObjectProperty op) {
        Set scopes = cLibrary.getIndividuals(ontology);
        ArrayList<String> result = new ArrayList<String>();
        for (OWLIndividual iLibrary : scopes) {
            if (!iLibrary.isNamed() || !((OWLNamedIndividual)iLibrary).getIRI().toString().equals(individualIRI)) continue;
            Set values = iLibrary.getObjectPropertyValues((OWLObjectPropertyExpression)op, ontology);
            for (OWLIndividual i : values) {
                if (!i.isNamed()) continue;
                result.add(((OWLNamedIndividual)iLibrary).getIRI().toString());
            }
        }
        return result.toArray(EMPTY_IRI_ARRAY);
    }

    public static String[] getCoreOntologies(OWLOntology config, String scopeIRI) {
        ArrayList<String> ontologies = new ArrayList<String>();
        ontologies.addAll(Arrays.asList(OntologyNetworkConfigurationUtils.getScopeObjectPropertyValues(config, scopeIRI, usesCoreOntology)));
        for (String libraryID : OntologyNetworkConfigurationUtils.getCoreLibraries(config, scopeIRI)) {
            ontologies.addAll(Arrays.asList(OntologyNetworkConfigurationUtils.getLibraryObjectPropertyValues(config, libraryID, libraryHasOntology)));
        }
        return ontologies.toArray(new String[ontologies.size()]);
    }

    public static String[] getCustomOntologies(OWLOntology config, String scopeIRI) {
        ArrayList<String> ontologies = new ArrayList<String>();
        ontologies.addAll(Arrays.asList(OntologyNetworkConfigurationUtils.getScopeObjectPropertyValues(config, scopeIRI, usesCustomOntology)));
        for (String libraryID : OntologyNetworkConfigurationUtils.getCustomLibraries(config, scopeIRI)) {
            ontologies.addAll(Arrays.asList(OntologyNetworkConfigurationUtils.getLibraryObjectPropertyValues(config, libraryID, libraryHasOntology)));
        }
        return ontologies.toArray(new String[ontologies.size()]);
    }

    private static String[] getCoreLibraries(OWLOntology config, String scopeIRI) {
        return OntologyNetworkConfigurationUtils.getScopeObjectPropertyValues(config, scopeIRI, usesCoreLibrary);
    }

    private static String[] getCustomLibraries(OWLOntology config, String scopeIRI) {
        return OntologyNetworkConfigurationUtils.getScopeObjectPropertyValues(config, scopeIRI, usesCustomLibrary);
    }
}

