/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.stanbol.enhancer.servicesapi.ContentSource;

public class ByteArraySource
implements ContentSource {
    private static final Map<String, List<String>> NO_HEADERS = Collections.emptyMap();
    private byte[] content;
    private String mt;
    private String name;
    private Map<String, List<String>> headers;

    public ByteArraySource(byte[] content) {
        this(content, null, null, null);
    }

    public ByteArraySource(byte[] content, String mt) {
        this(content, mt, null, null);
    }

    public ByteArraySource(byte[] content, String mt, String fileName) {
        this(content, mt, fileName, null);
    }

    public ByteArraySource(byte[] content, String mt, String fileName, Map<String, List<String>> headers) {
        if (content == null) {
            throw new IllegalArgumentException("The parsed byte array MUST NOT be NULL!");
        }
        this.content = content;
        this.mt = mt == null ? "application/octet-stream" : mt;
        this.name = fileName;
        this.headers = headers == null ? NO_HEADERS : headers;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public byte[] getData() throws IOException {
        return this.content;
    }

    @Override
    public String getMediaType() {
        return this.mt;
    }

    @Override
    public String getFileName() {
        return this.name;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }
}

