/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.ContentItemFactory;
import org.apache.stanbol.enhancer.servicesapi.ContentReference;
import org.apache.stanbol.enhancer.servicesapi.ContentSink;
import org.apache.stanbol.enhancer.servicesapi.ContentSource;

@Component(componentAbstract=true, immediate=true, policy=ConfigurationPolicy.OPTIONAL)
@Service(value={ContentItemFactory.class})
public abstract class AbstractContentItemFactory
implements ContentItemFactory {
    private final boolean lazyLoadingBlobsEnabled;

    protected AbstractContentItemFactory() {
        this(false);
    }

    protected AbstractContentItemFactory(boolean enableLazyDereferencingBlobs) {
        this.lazyLoadingBlobsEnabled = enableLazyDereferencingBlobs;
    }

    @Override
    public final ContentItem createContentItem(ContentSource source) throws IOException {
        return this.createContentItem((IRI)null, source, null);
    }

    @Override
    public final ContentItem createContentItem(String prefix, ContentSource source) throws IOException {
        return this.createContentItem(prefix, source, null);
    }

    @Override
    public final ContentItem createContentItem(IRI id, ContentSource source) throws IOException {
        return this.createContentItem(id, source, null);
    }

    @Override
    public final ContentItem createContentItem(ContentReference reference) throws IOException {
        return this.createContentItem(reference, null);
    }

    @Override
    public final ContentItem createContentItem(ContentReference reference, Graph metadata) throws IOException {
        if (reference == null) {
            throw new IllegalArgumentException("The parsed ContentReference MUST NOT be NULL!");
        }
        return this.createContentItem(new IRI(reference.getReference()), this.createBlob(reference), metadata);
    }

    @Override
    public final ContentItem createContentItem(String prefix, ContentSource source, Graph metadata) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("The parsed prefix MUST NOT be NULL!");
        }
        if (source == null) {
            throw new IllegalArgumentException("The parsed ContentSource MUST NOT be NULL!");
        }
        return this.createContentItem(prefix, this.createBlob(source), metadata);
    }

    @Override
    public final ContentItem createContentItem(IRI id, ContentSource source, Graph metadata) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("The parsed ContentSource MUST NOT be NULL!");
        }
        return this.createContentItem(id, this.createBlob(source), metadata);
    }

    protected abstract ContentItem createContentItem(IRI var1, Blob var2, Graph var3);

    protected abstract ContentItem createContentItem(String var1, Blob var2, Graph var3);

    @Override
    public abstract Blob createBlob(ContentSource var1) throws IOException;

    @Override
    public abstract ContentSink createContentSink(String var1) throws IOException;

    public boolean isLazyDereferenceing() {
        return this.lazyLoadingBlobsEnabled;
    }

    @Override
    public final Blob createBlob(ContentReference reference) throws IOException {
        if (reference == null) {
            throw new IllegalArgumentException("The passed ContentReference MUST NOT be NULL!");
        }
        if (this.lazyLoadingBlobsEnabled) {
            return new LazyDereferencingBlob(reference);
        }
        return this.createBlob(reference.dereference());
    }

    protected class LazyDereferencingBlob
    implements Blob {
        private final ContentReference contentReference;
        private Blob _blob;

        protected LazyDereferencingBlob(ContentReference contentReference) {
            this.contentReference = contentReference;
        }

        @Override
        public String getMimeType() {
            return this.getLazy().getMimeType();
        }

        @Override
        public InputStream getStream() {
            return this.getLazy().getStream();
        }

        @Override
        public Map<String, String> getParameter() {
            return this.getLazy().getParameter();
        }

        @Override
        public long getContentLength() {
            if (this._blob == null) {
                return -1L;
            }
            return this._blob.getContentLength();
        }

        public Blob getLazy() {
            if (this._blob == null) {
                try {
                    this._blob = AbstractContentItemFactory.this.createBlob(this.contentReference.dereference());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to derefernece content reference '" + this.contentReference.getReference() + " (Message: " + e.getMessage() + ")!", e);
                }
            }
            return this._blob;
        }
    }
}

