/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper.execution;

import java.util.Date;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionMetadataHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.ChainExecution;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.ExecutionNode;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionMetadata;

public class Execution
implements Comparable<Execution> {
    protected final BlankNodeOrIRI node;
    private final ExecutionNode executionNode;
    private final IRI status;
    protected final Graph graph;
    private final Date started;
    private final Date completed;
    private final Long duration;
    private final ChainExecution chain;

    public Execution(ChainExecution parent, Graph graph, BlankNodeOrIRI node) {
        this.chain = parent;
        this.graph = graph;
        this.node = node;
        BlankNodeOrIRI executionNode = ExecutionMetadataHelper.getExecutionNode(graph, node);
        this.executionNode = executionNode != null ? new ExecutionNode(graph, executionNode) : null;
        this.status = EnhancementEngineHelper.getReference(graph, node, ExecutionMetadata.STATUS);
        this.started = ExecutionMetadataHelper.getStarted(graph, node);
        this.completed = ExecutionMetadataHelper.getCompleted(graph, node);
        this.duration = this.started != null && this.completed != null ? Long.valueOf(this.completed.getTime() - this.started.getTime()) : null;
    }

    public final IRI getStatus() {
        return this.status;
    }

    public final Date getStarted() {
        return this.started;
    }

    public final Long getDuration() {
        return this.duration;
    }

    public ExecutionNode getExecutionNode() {
        return this.executionNode;
    }

    public Date getCompleted() {
        return this.completed;
    }

    public boolean isFailed() {
        return ExecutionMetadata.STATUS_FAILED.equals((Object)this.status);
    }

    public boolean isCompleted() {
        return ExecutionMetadata.STATUS_COMPLETED.equals((Object)this.status);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ExecutionNode && ((ExecutionNode)o).node.equals(this.node);
    }

    @Override
    public int compareTo(Execution e2) {
        if (this.started != null && e2.started != null) {
            int result = this.started.compareTo(e2.started);
            if (result == 0) {
                if (this.completed != null && e2.completed != null) {
                    result = this.started.compareTo(e2.completed);
                    if (result == 0) {
                        return this.node.toString().compareTo(e2.toString());
                    }
                    return result;
                }
                if (this.completed == null && e2.completed == null) {
                    return this.node.toString().compareTo(e2.toString());
                }
                return this.completed == null ? -1 : 1;
            }
            return result;
        }
        if (this.started == null && e2.started == null) {
            return this.node.toString().compareTo(e2.toString());
        }
        return this.started == null ? -1 : 1;
    }

    public ChainExecution getChain() {
        return this.chain;
    }
}

