/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.PlainLiteralImpl;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.stanbol.commons.indexedgraph.IndexedGraph;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionMetadata;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionPlan;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;

public final class ExecutionMetadataHelper {
    private static final LiteralFactory lf = LiteralFactory.getInstance();

    private ExecutionMetadataHelper() {
    }

    public static BlankNodeOrIRI createChainExecutionNode(Graph graph, BlankNodeOrIRI executionPlan, IRI ciUri, boolean defaultChain) {
        BlankNode node = new BlankNode();
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, Properties.RDF_TYPE, (RDFTerm)ExecutionMetadata.EXECUTION));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, Properties.RDF_TYPE, (RDFTerm)ExecutionMetadata.CHAIN_EXECUTION));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionMetadata.ENHANCES, (RDFTerm)ciUri));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)ciUri, ExecutionMetadata.ENHANCED_BY, (RDFTerm)node));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionMetadata.STATUS, (RDFTerm)ExecutionMetadata.STATUS_SCHEDULED));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionMetadata.EXECUTION_PLAN, (RDFTerm)executionPlan));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionMetadata.IS_DEFAULT_CHAIN, (RDFTerm)lf.createTypedLiteral((Object)defaultChain)));
        return node;
    }

    public static BlankNodeOrIRI createEngineExecution(Graph graph, BlankNodeOrIRI chainExecution, BlankNodeOrIRI executionNode) {
        BlankNode node = new BlankNode();
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, Properties.RDF_TYPE, (RDFTerm)ExecutionMetadata.EXECUTION));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, Properties.RDF_TYPE, (RDFTerm)ExecutionMetadata.ENGINE_EXECUTION));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionMetadata.EXECUTION_PART, (RDFTerm)chainExecution));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionMetadata.EXECUTION_NODE, (RDFTerm)executionNode));
        graph.add((Object)new TripleImpl((BlankNodeOrIRI)node, ExecutionMetadata.STATUS, (RDFTerm)ExecutionMetadata.STATUS_SCHEDULED));
        return node;
    }

    public static void setExecutionCompleted(Graph graph, BlankNodeOrIRI execution, String message) {
        Literal dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_COMPLETED);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.COMPLETED, (RDFTerm)dateTime));
        if (message != null) {
            graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS_MESSAGE, (RDFTerm)new PlainLiteralImpl(message)));
        }
    }

    public static void setExecutionScheduled(Graph graph, BlankNodeOrIRI execution) {
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_SCHEDULED);
        Iterator it = graph.filter(execution, ExecutionMetadata.STARTED, null);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        it = graph.filter(execution, ExecutionMetadata.COMPLETED, null);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public static void setExecutionFaild(Graph graph, BlankNodeOrIRI execution, String message) {
        Literal dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_FAILED);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.COMPLETED, (RDFTerm)dateTime));
        if (message == null) {
            throw new IllegalArgumentException("For faild Execution a STATUS message is required!");
        }
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS_MESSAGE, (RDFTerm)new PlainLiteralImpl(message)));
    }

    public static void setExecutionSkipped(Graph graph, BlankNodeOrIRI execution, String message) {
        Literal dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_SKIPPED);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STARTED, (RDFTerm)dateTime));
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.COMPLETED, (RDFTerm)dateTime));
        if (message != null) {
            graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS_MESSAGE, (RDFTerm)new PlainLiteralImpl(message)));
        }
    }

    public static void setExecutionInProgress(Graph graph, BlankNodeOrIRI execution) {
        Literal dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_IN_PROGRESS);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STARTED, (RDFTerm)dateTime));
    }

    private static void setStatus(Graph graph, BlankNodeOrIRI execution, IRI status) {
        Iterator it = graph.filter(execution, ExecutionMetadata.STATUS, null);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        if (status != null) {
            graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS, (RDFTerm)status));
        }
    }

    public static final BlankNodeOrIRI getChainExecutionForChainName(Graph em, Graph ep, String chainName) {
        BlankNodeOrIRI executionPlanNode = ExecutionPlanHelper.getExecutionPlan(ep, chainName);
        if (executionPlanNode == null) {
            return null;
        }
        return ExecutionMetadataHelper.getChainExecutionForExecutionPlan(em, executionPlanNode);
    }

    public static BlankNodeOrIRI getChainExecutionForExecutionPlan(Graph graph, BlankNodeOrIRI executionPlanNode) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed graph with the execution metadata MUST NOT be NULL!");
        }
        if (executionPlanNode == null) {
            throw new IllegalArgumentException("The parsed execution plan node MUST NOT be NULL!");
        }
        Iterator it = graph.filter(null, ExecutionMetadata.EXECUTION_PLAN, (RDFTerm)executionPlanNode);
        if (it.hasNext()) {
            return ((Triple)it.next()).getSubject();
        }
        return null;
    }

    public static Graph getExecutionMetadata(ContentItem contentItem) {
        if (contentItem == null) {
            throw new IllegalArgumentException("The parsed ContentItme MUST NOT be NULL!");
        }
        contentItem.getLock().readLock().lock();
        try {
            Graph graph = contentItem.getPart(ExecutionMetadata.CHAIN_EXECUTION, Graph.class);
            return graph;
        }
        finally {
            contentItem.getLock().readLock().unlock();
        }
    }

    public static Graph initExecutionMetadataContentPart(ContentItem contentItem) {
        Graph executionMetadata;
        if (contentItem == null) {
            throw new IllegalArgumentException("The parsed ContentItme MUST NOT be NULL!");
        }
        contentItem.getLock().writeLock().lock();
        try {
            try {
                executionMetadata = contentItem.getPart(ExecutionMetadata.CHAIN_EXECUTION, Graph.class);
            }
            catch (NoSuchPartException e) {
                executionMetadata = new IndexedGraph();
                contentItem.addPart(ExecutionMetadata.CHAIN_EXECUTION, executionMetadata);
            }
        }
        finally {
            contentItem.getLock().writeLock().unlock();
        }
        return executionMetadata;
    }

    public static final Map<BlankNodeOrIRI, BlankNodeOrIRI> initExecutionMetadata(Graph em, Graph ep, IRI ciUri, String chainName, Boolean isDefaultChain) {
        BlankNodeOrIRI executionPlanNode;
        if (em == null) {
            throw new IllegalArgumentException("The parsed ExecutionMetadata graph MUST NOT be NULL!");
        }
        if (ciUri == null) {
            throw new IllegalArgumentException("The parsed URI of the contentItem MUST NOT be NULL!");
        }
        BlankNodeOrIRI chainExecutionNode = ExecutionMetadataHelper.getChainExecutionForExecutionPlan(em, (BlankNodeOrIRI)ciUri);
        if (chainExecutionNode != null) {
            executionPlanNode = ExecutionMetadataHelper.getExecutionPlanNode(em, chainExecutionNode);
            if (executionPlanNode == null) {
                throw new IllegalArgumentException("The em:ChainExecution '" + chainExecutionNode + "'that enhances ContentItem '" + ciUri + "' does not define a link to an valid ExecutionPlan");
            }
            isDefaultChain = EnhancementEngineHelper.get(em, chainExecutionNode, ExecutionMetadata.IS_DEFAULT_CHAIN, Boolean.class, lf);
            String extractedChainName = EnhancementEngineHelper.getString(ep, executionPlanNode, ExecutionPlan.CHAIN);
            if (extractedChainName == null) {
                throw new IllegalArgumentException("The em:ChainExecution '" + chainExecutionNode + "'that enhances ContentItem '" + ciUri + "' links to the ep:ExecutionPlan '" + executionPlanNode + "' that does not define a ChainName (property: " + ExecutionPlan.CHAIN + ")!");
            }
            if (chainName == null) {
                chainName = extractedChainName;
            } else if (!chainName.equals(extractedChainName)) {
                throw new IllegalArgumentException("The em:ChainExecution '" + chainExecutionNode + "'that enhances ContentItem '" + ciUri + "' links to the ep:ExecutionPlan '" + executionPlanNode + "' with the chain name '" + extractedChainName + "' but '" + chainName + "' was parsed " + "as expected chain name!");
            }
        } else {
            executionPlanNode = ExecutionPlanHelper.getExecutionPlan(ep, chainName);
            if (executionPlanNode == null) {
                throw new IllegalArgumentException("The parsed ExectuonPlan graph does not contain anExecutionPlan for a Chain with the name '" + chainName + "'!");
            }
            if (isDefaultChain == null) {
                throw new IllegalArgumentException("The isDefaultChain parameter MUST NOTbe NULL if initialising from empty ExecutionMetadata!");
            }
            chainExecutionNode = ExecutionMetadataHelper.createChainExecutionNode(em, executionPlanNode, ciUri, isDefaultChain);
        }
        HashMap<BlankNodeOrIRI, BlankNodeOrIRI> executionsMap = new HashMap<BlankNodeOrIRI, BlankNodeOrIRI>();
        Set<BlankNodeOrIRI> executionNodes = ExecutionPlanHelper.getExecutionNodes(ep, executionPlanNode);
        Set<BlankNodeOrIRI> executions = ExecutionMetadataHelper.getExecutions(em, chainExecutionNode);
        for (BlankNodeOrIRI en : executionNodes) {
            BlankNodeOrIRI execution;
            Iterator it = em.filter(null, ExecutionMetadata.EXECUTION_NODE, (RDFTerm)en);
            if (it.hasNext()) {
                execution = ((Triple)it.next()).getSubject();
                if (!executions.contains(execution)) {
                    throw new IllegalStateException("Execution '" + execution + "' for ExecutionNode '" + en + "' (engine: '" + ExecutionPlanHelper.getEngine(ep, en) + "') is not part of ChainExecution '" + chainExecutionNode + "' (chain: '" + chainName + ")!");
                }
            } else {
                execution = ExecutionMetadataHelper.createEngineExecution(em, chainExecutionNode, en);
                executions.add(execution);
            }
            executionsMap.put(execution, en);
        }
        for (BlankNodeOrIRI e : executions) {
            if (executionsMap.containsKey(e)) continue;
            BlankNodeOrIRI en = ExecutionMetadataHelper.getExecutionNode(em, e);
            throw new IllegalStateException("ChainExecution '" + chainExecutionNode + "' (chain: '" + chainName + ") contains" + "Execution '" + e + "' for ExecutionNode '" + en + "' (engine: '" + ExecutionPlanHelper.getEngine(ep, en) + "') that is not part of the pased ExecutionPlan '" + executionPlanNode + "'(chain; '" + chainName + "')!");
        }
        return executionsMap;
    }

    public static BlankNodeOrIRI getExecutionNode(Graph graph, BlankNodeOrIRI execution) {
        Iterator it = graph.filter(execution, ExecutionMetadata.EXECUTION_NODE, null);
        if (it.hasNext()) {
            Triple t = (Triple)it.next();
            RDFTerm o = t.getObject();
            if (o instanceof BlankNodeOrIRI) {
                return (BlankNodeOrIRI)o;
            }
            throw new IllegalStateException("Value of property " + ExecutionMetadata.EXECUTION_NODE + "MUST BE of type BlankNodeOrIRI (triple: '" + t + "')!");
        }
        return null;
    }

    public static Set<BlankNodeOrIRI> getExecutions(Graph em, BlankNodeOrIRI chainExecutionNode) {
        if (em == null) {
            throw new IllegalArgumentException("The parsed graph with the Execution metadata MUST NOT be NULL!");
        }
        if (chainExecutionNode == null) {
            throw new IllegalArgumentException("The parsed chain execution plan node MUST NOT be NULL!");
        }
        HashSet<BlankNodeOrIRI> executionNodes = new HashSet<BlankNodeOrIRI>();
        Iterator it = em.filter(null, ExecutionMetadata.EXECUTION_PART, (RDFTerm)chainExecutionNode);
        while (it.hasNext()) {
            executionNodes.add(((Triple)it.next()).getSubject());
        }
        return executionNodes;
    }

    public static BlankNodeOrIRI getExecutionPlanNode(Graph em, BlankNodeOrIRI chainExecutionNode) {
        Iterator it = em.filter(chainExecutionNode, ExecutionMetadata.EXECUTION_PLAN, null);
        if (it.hasNext()) {
            Triple t = (Triple)it.next();
            RDFTerm r = t.getObject();
            if (r instanceof BlankNodeOrIRI) {
                return (BlankNodeOrIRI)r;
            }
            throw new IllegalStateException("Value of the property " + ExecutionMetadata.EXECUTION_PLAN + " MUST BE a BlankNodeOrIRI (triple: '" + t + "')!");
        }
        return null;
    }

    public static BlankNodeOrIRI getChainExecution(Graph em, IRI ciUri) {
        Iterator it = em.filter(null, ExecutionMetadata.ENHANCES, (RDFTerm)ciUri);
        if (it.hasNext()) {
            return ((Triple)it.next()).getSubject();
        }
        return null;
    }

    public static boolean isExecutionFailed(Graph graph, BlankNodeOrIRI execution) {
        return ExecutionMetadata.STATUS_FAILED.equals((Object)EnhancementEngineHelper.getReference(graph, execution, ExecutionMetadata.STATUS));
    }

    public static boolean isExecutionFinished(Graph graph, BlankNodeOrIRI execution) {
        IRI status = EnhancementEngineHelper.getReference(graph, execution, ExecutionMetadata.STATUS);
        return ExecutionMetadata.STATUS_FAILED.equals((Object)status) || ExecutionMetadata.STATUS_COMPLETED.equals((Object)status);
    }

    public static Date getStarted(Graph graph, BlankNodeOrIRI execution) {
        return EnhancementEngineHelper.get(graph, execution, ExecutionMetadata.STARTED, Date.class, lf);
    }

    public static Date getCompleted(Graph graph, BlankNodeOrIRI execution) {
        return EnhancementEngineHelper.get(graph, execution, ExecutionMetadata.COMPLETED, Date.class, lf);
    }
}

