/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Language;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.PlainLiteralImpl;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.rdf.core.InvalidLiteralTypeException;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementPropertyException;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;
import org.apache.stanbol.enhancer.servicesapi.ServiceProperties;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.DictionaryAdapter;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionMetadataHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionPlan;
import org.apache.stanbol.enhancer.servicesapi.rdf.NamespaceEnum;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;
import org.apache.stanbol.enhancer.servicesapi.rdf.TechnicalClasses;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnhancementEngineHelper {
    public static final int DEFAULT_SELECTION_CONTEXT_PREFIX_SUFFIX_SIZE = 50;
    public static final int MIN_SELECTION_CONTEXT_PREFIX_SUFFIX_SIZE = 15;
    public static final int MIN_SELECTEN_HEAD_TAIL_USAGE_LENGTH = 30;
    public static final int DEFAULT_PREFIX_SUFFIX_LENGTH = 10;
    public static final int MIN_PREFIX_SUFFIX_SIZE = 3;
    protected static final Random rng = new Random();
    private static final Logger log = LoggerFactory.getLogger(EnhancementEngineHelper.class);
    private static final LiteralFactory lf = LiteralFactory.getInstance();
    public static final Comparator<EnhancementEngine> EXECUTION_ORDER_COMPARATOR = new Comparator<EnhancementEngine>(){

        @Override
        public int compare(EnhancementEngine engine1, EnhancementEngine engine2) {
            Integer order2;
            Integer order1 = EnhancementEngineHelper.getEngineOrder(engine1);
            return order1 == (order2 = EnhancementEngineHelper.getEngineOrder(engine2)) ? 0 : (order1 < order2 ? 1 : -1);
        }
    };
    private static final String EHPROP_NS = NamespaceEnum.ehp.getNamespace();
    private static final int EHPROP_NS_LENGTH = EHPROP_NS.length();

    private EnhancementEngineHelper() {
    }

    public static void setSeed(long seed) {
        rng.setSeed(seed);
    }

    public static IRI createTextEnhancement(ContentItem ci, EnhancementEngine engine) {
        return EnhancementEngineHelper.createTextEnhancement(ci.getMetadata(), engine, new IRI(ci.getUri().getUnicodeString()));
    }

    public static IRI createTextEnhancement(Graph metadata, EnhancementEngine engine, IRI contentItemId) {
        IRI enhancement = EnhancementEngineHelper.createEnhancement(metadata, engine, contentItemId);
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TEXTANNOTATION));
        return enhancement;
    }

    public static void setOccurrence(Graph metadata, IRI textAnnotation, String content, Integer start, Integer end, Language lang, int prefixSuffixSize, boolean allowSelectionHeadTail) {
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_START, (RDFTerm)lf.createTypedLiteral((Object)start)));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_END, (RDFTerm)lf.createTypedLiteral((Object)end)));
        prefixSuffixSize = prefixSuffixSize < 3 ? 10 : prefixSuffixSize;
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_PREFIX, (RDFTerm)new PlainLiteralImpl(content.substring(Math.max(0, start - prefixSuffixSize), start), lang)));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_SUFFIX, (RDFTerm)new PlainLiteralImpl(content.substring(end, Math.min(content.length(), end + prefixSuffixSize)), lang)));
        int maxSelectedTextSize = Math.max(30, prefixSuffixSize * 5);
        if (!allowSelectionHeadTail || end - start <= maxSelectedTextSize) {
            metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTED_TEXT, (RDFTerm)new PlainLiteralImpl(content.substring(start, end), lang)));
        } else {
            metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_HEAD, (RDFTerm)new PlainLiteralImpl(content.substring(start, start + prefixSuffixSize), lang)));
            metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, Properties.ENHANCER_SELECTION_TAIL, (RDFTerm)new PlainLiteralImpl(content.substring(end - prefixSuffixSize, end), lang)));
        }
    }

    public static String getSelectionContext(String content, String selection, int selectionStartPos) {
        return EnhancementEngineHelper.getSelectionContext(content, selection, selectionStartPos, 50);
    }

    public static String getSelectionContext(String content, String selection, int selectionStartPos, int contextSize) {
        int endPos;
        int beginPos;
        if (contextSize < 0) {
            contextSize = 50;
        }
        if (contextSize < 15) {
            contextSize = 3;
        }
        if (selectionStartPos <= 50) {
            beginPos = 0;
        } else {
            int start = selectionStartPos - 50;
            beginPos = content.indexOf(32, start);
            if (beginPos < 0 || beginPos >= selectionStartPos) {
                beginPos = start;
            }
        }
        if (selectionStartPos + selection.length() + 50 >= content.length()) {
            endPos = content.length();
        } else {
            int start = selectionStartPos + selection.length() + 50;
            endPos = content.lastIndexOf(32, start);
            if (endPos <= selectionStartPos + selection.length()) {
                endPos = start;
            }
        }
        return content.substring(beginPos, endPos);
    }

    public static IRI createEntityEnhancement(ContentItem ci, EnhancementEngine engine) {
        return EnhancementEngineHelper.createEntityEnhancement(ci.getMetadata(), engine, new IRI(ci.getUri().getUnicodeString()));
    }

    public static IRI createEntityEnhancement(Graph metadata, EnhancementEngine engine, IRI contentItemId) {
        IRI enhancement = EnhancementEngineHelper.createEnhancement(metadata, engine, contentItemId);
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_ENTITYANNOTATION));
        return enhancement;
    }

    public static IRI createTopicEnhancement(Graph metadata, EnhancementEngine engine, IRI contentItemId) {
        IRI enhancement = EnhancementEngineHelper.createEnhancement(metadata, engine, contentItemId);
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TOPICANNOTATION));
        return enhancement;
    }

    public static IRI createTopicEnhancement(ContentItem ci, EnhancementEngine engine) {
        return EnhancementEngineHelper.createTopicEnhancement(ci.getMetadata(), engine, new IRI(ci.getUri().getUnicodeString()));
    }

    public static IRI createEnhancement(Graph metadata, EnhancementEngine engine, IRI contentItemId) {
        LiteralFactory literalFactory = LiteralFactory.getInstance();
        IRI enhancement = new IRI("urn:enhancement-" + EnhancementEngineHelper.randomUUID());
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_ENHANCEMENT));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.ENHANCER_EXTRACTED_FROM, (RDFTerm)contentItemId));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.DC_CREATED, (RDFTerm)literalFactory.createTypedLiteral((Object)new Date())));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.DC_CREATOR, (RDFTerm)literalFactory.createTypedLiteral((Object)engine.getClass().getName())));
        return enhancement;
    }

    public static void addContributingEngine(Graph metadata, IRI enhancement, EnhancementEngine engine) {
        LiteralFactory literalFactory = LiteralFactory.getInstance();
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, Properties.DC_CONTRIBUTOR, (RDFTerm)literalFactory.createTypedLiteral((Object)engine.getClass().getName())));
        EnhancementEngineHelper.set(metadata, (BlankNodeOrIRI)enhancement, Properties.DC_MODIFIED, new Date(), literalFactory);
    }

    @Deprecated
    public static IRI createNewExtraction(ContentItem ci, EnhancementEngine engine) {
        LiteralFactory literalFactory = LiteralFactory.getInstance();
        Graph metadata = ci.getMetadata();
        IRI extraction = new IRI("urn:extraction-" + EnhancementEngineHelper.randomUUID());
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)extraction, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_EXTRACTION));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)extraction, Properties.ENHANCER_RELATED_CONTENT_ITEM, (RDFTerm)new IRI(ci.getUri().getUnicodeString())));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)extraction, Properties.DC_CREATED, (RDFTerm)literalFactory.createTypedLiteral((Object)new Date())));
        metadata.add((Object)new TripleImpl((BlankNodeOrIRI)extraction, Properties.DC_CREATOR, (RDFTerm)literalFactory.createTypedLiteral((Object)engine.getClass().getName())));
        return extraction;
    }

    public static UUID randomUUID() {
        return new UUID(rng.nextLong(), rng.nextLong());
    }

    public static <T> T get(Graph graph, BlankNodeOrIRI resource, IRI property, Class<T> type, LiteralFactory literalFactory) {
        Iterator results = graph.filter(resource, property, null);
        if (results.hasNext()) {
            while (results.hasNext()) {
                Triple result = (Triple)results.next();
                if (result.getObject() instanceof Literal) {
                    return (T)literalFactory.createObject(type, (Literal)result.getObject());
                }
                log.debug("Triple {} does not have a Literal as object! -> ignore", (Object)result);
            }
            log.info("No value for {} and property {} had the requested Type {} -> return null", new Object[]{resource, property, type});
            return null;
        }
        log.debug("No Triple found for {} and property {}! -> return null", (Object)resource, (Object)property);
        return null;
    }

    public static void set(Graph graph, BlankNodeOrIRI resource, IRI property, RDFTerm value) {
        EnhancementEngineHelper.set(graph, resource, property, value == null ? null : Collections.singleton(value), null);
    }

    public static void set(Graph graph, BlankNodeOrIRI resource, IRI property, Collection<RDFTerm> values) {
        EnhancementEngineHelper.set(graph, resource, property, values, null);
    }

    public static void set(Graph graph, BlankNodeOrIRI resource, IRI property, Object value, LiteralFactory literalFactory) {
        EnhancementEngineHelper.set(graph, resource, property, value == null ? null : Collections.singleton(value), literalFactory);
    }

    public static void set(Graph graph, BlankNodeOrIRI resource, IRI property, Collection<?> values, LiteralFactory literalFactory) {
        Iterator currentValues = graph.filter(resource, property, null);
        while (currentValues.hasNext()) {
            currentValues.next();
            currentValues.remove();
        }
        if (values != null) {
            for (Object value : values) {
                if (value instanceof RDFTerm) {
                    graph.add((Object)new TripleImpl(resource, property, (RDFTerm)value));
                    continue;
                }
                if (value == null) continue;
                graph.add((Object)new TripleImpl(resource, property, (RDFTerm)literalFactory.createTypedLiteral(value)));
            }
        }
    }

    public static <T> Iterator<T> getValues(Graph graph, BlankNodeOrIRI resource, IRI property, final Class<T> type, final LiteralFactory literalFactory) {
        final Iterator results = graph.filter(resource, property, null);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public T next() {
                return literalFactory.createObject(type, (Literal)((Triple)results.next()).getObject());
            }

            @Override
            public void remove() {
                results.remove();
            }
        };
    }

    public static String getString(Graph graph, BlankNodeOrIRI resource, IRI property) {
        Iterator results = graph.filter(resource, property, null);
        if (results.hasNext()) {
            while (results.hasNext()) {
                Triple result = (Triple)results.next();
                if (result.getObject() instanceof Literal) {
                    return ((Literal)result.getObject()).getLexicalForm();
                }
                log.debug("Triple {} does not have a literal as object! -> ignore", (Object)result);
            }
            log.info("No Literal value for {} and property {} -> return null", (Object)resource, (Object)property);
            return null;
        }
        log.debug("No Triple found for " + resource + " and property " + property + "! -> return null");
        return null;
    }

    public static Iterator<String> getStrings(Graph graph, BlankNodeOrIRI resource, IRI property) {
        final Iterator results = graph.filter(resource, property, null);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public String next() {
                return ((Literal)((Triple)results.next()).getObject()).getLexicalForm();
            }

            @Override
            public void remove() {
                results.remove();
            }
        };
    }

    public static IRI getReference(Graph graph, BlankNodeOrIRI resource, IRI property) {
        Iterator results = graph.filter(resource, property, null);
        if (results.hasNext()) {
            while (results.hasNext()) {
                Triple result = (Triple)results.next();
                if (result.getObject() instanceof IRI) {
                    return (IRI)result.getObject();
                }
                log.debug("Triple " + result + " does not have a IRI as object! -> ignore");
            }
            log.info("No IRI value for {} and property {} -> return null", (Object)resource, (Object)property);
            return null;
        }
        log.debug("No Triple found for {} and property {}! -> return null", (Object)resource, (Object)property);
        return null;
    }

    public static Iterator<IRI> getReferences(Graph graph, BlankNodeOrIRI resource, IRI property) {
        final Iterator results = graph.filter(resource, property, null);
        return new Iterator<IRI>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public IRI next() {
                return (IRI)((Triple)results.next()).getObject();
            }

            @Override
            public void remove() {
                results.remove();
            }
        };
    }

    public static Integer getEngineOrder(EnhancementEngine engine) {
        log.debug("getOrder " + engine);
        if (engine instanceof ServiceProperties) {
            log.debug(" ... implements ServiceProperties");
            Object value = ((ServiceProperties)((Object)engine)).getServiceProperties().get("org.apache.stanbol.enhancer.engine.order");
            log.debug("   > value = " + value + " " + value.getClass());
            if (value != null && value instanceof Integer) {
                return (Integer)value;
            }
        }
        return ServiceProperties.ORDERING_DEFAULT;
    }

    public static List<BlankNodeOrIRI> getLanguageAnnotations(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed graph MUST NOT be NULL!");
        }
        final HashMap<BlankNodeOrIRI, Double> confidences = new HashMap<BlankNodeOrIRI, Double>();
        ArrayList<BlankNodeOrIRI> langAnnotations = new ArrayList<BlankNodeOrIRI>();
        Iterator textAnnoataions = graph.filter(null, Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TEXTANNOTATION);
        while (textAnnoataions.hasNext()) {
            BlankNodeOrIRI textAnnotation = ((Triple)textAnnoataions.next()).getSubject();
            String language = EnhancementEngineHelper.getString(graph, textAnnotation, Properties.DC_LANGUAGE);
            if (language == null) continue;
            Double confidence = null;
            try {
                confidence = EnhancementEngineHelper.get(graph, textAnnotation, Properties.ENHANCER_CONFIDENCE, Double.class, lf);
            }
            catch (InvalidLiteralTypeException e) {
                try {
                    Float fconf = EnhancementEngineHelper.get(graph, textAnnotation, Properties.ENHANCER_CONFIDENCE, Float.class, lf);
                    if (fconf != null) {
                        confidence = fconf.doubleValue();
                    }
                }
                catch (InvalidLiteralTypeException e1) {
                    log.warn("Unable to parse confidence for language annotation " + textAnnotation, (Throwable)e);
                }
            }
            confidences.put(textAnnotation, confidence);
            langAnnotations.add(textAnnotation);
        }
        if (langAnnotations.size() > 1) {
            Collections.sort(langAnnotations, new Comparator<BlankNodeOrIRI>(){

                @Override
                public int compare(BlankNodeOrIRI o1, BlankNodeOrIRI o2) {
                    Double c1 = (Double)confidences.get(o1);
                    Double c2 = (Double)confidences.get(o2);
                    if (c1 == null) {
                        return c2 == null ? 0 : 1;
                    }
                    if (c2 == null) {
                        return -1;
                    }
                    return c2.compareTo(c1);
                }
            });
        }
        return langAnnotations;
    }

    public static String getLanguage(ContentItem ci) {
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL!");
        }
        ci.getLock().readLock().lock();
        try {
            List<BlankNodeOrIRI> langAnnotations = EnhancementEngineHelper.getLanguageAnnotations(ci.getMetadata());
            if (langAnnotations.isEmpty()) {
                String string = EnhancementEngineHelper.getString(ci.getMetadata(), (BlankNodeOrIRI)ci.getUri(), Properties.DC_LANGUAGE);
                return string;
            }
            String string = EnhancementEngineHelper.getString(ci.getMetadata(), langAnnotations.get(0), Properties.DC_LANGUAGE);
            return string;
        }
        finally {
            ci.getLock().readLock().unlock();
        }
    }

    public static Dictionary<String, Object> getEnhancementPropertyDict(EnhancementEngine engine, ContentItem ci) {
        return new DictionaryAdapter<String, Object>(EnhancementEngineHelper.getEnhancementProperties(engine, ci));
    }

    public static Map<String, Object> getEnhancementProperties(EnhancementEngine engine, ContentItem ci) {
        if (engine == null) {
            throw new IllegalArgumentException("The parsed EnhancementEngine MUST NOT be NULL");
        }
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL");
        }
        Map<String, Object> chainExProps = EnhancementEngineHelper.getChainExecutionProperties(engine, ci);
        Map<String, Object> epContentPart = ContentItemHelper.getRequestPropertiesContentPart(ci);
        HashMap<String, Object> chainProperties = new HashMap<String, Object>();
        HashMap<String, Object> engineProperties = new HashMap<String, Object>();
        if (epContentPart != null) {
            String enginePrefix = engine.getName() + ':';
            log.debug("Retrieve EnhancementProperties for Engine {} and ContentItem {}", (Object)engine.getName(), (Object)ci.getUri());
            for (Map.Entry<String, Object> entry : epContentPart.entrySet()) {
                String key = entry.getKey();
                int sepIndex = key.indexOf(58);
                if (sepIndex < 0) {
                    log.debug(" ... add chain request level property {}='{}'", (Object)key, entry.getValue());
                    chainProperties.put(key, entry.getValue());
                    continue;
                }
                if (!key.startsWith(enginePrefix) || key.length() <= enginePrefix.length()) continue;
                key = key.substring(enginePrefix.length(), key.length());
                log.debug(" ... add engine request level property {}='{}'", (Object)key, entry.getValue());
                engineProperties.put(key, entry.getValue());
            }
        } else {
            log.debug(" - no Request scope EnhancementProperties for ContentItem", (Object)ci.getUri());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(chainExProps);
        properties.putAll(chainProperties);
        properties.putAll(engineProperties);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getChainExecutionProperties(EnhancementEngine engine, ContentItem ci) {
        if (engine == null) {
            throw new IllegalArgumentException("The parsed EnhancementEngine MUST NOT be NULL");
        }
        if (ci == null) {
            throw new IllegalArgumentException("The parsed ContentItem MUST NOT be NULL");
        }
        HashMap<String, Object> chainExProps = new HashMap<String, Object>();
        HashMap<String, Object> engineExProps = new HashMap<String, Object>();
        ci.getLock().readLock().lock();
        try {
            Graph em = ExecutionMetadataHelper.getExecutionMetadata(ci);
            log.debug("> extract EnhancementProperties form the ExecutionPlan");
            BlankNodeOrIRI executionPlanNode = ExecutionMetadataHelper.getExecutionPlanNode(em, ExecutionMetadataHelper.getChainExecution(em, ci.getUri()));
            EnhancementEngineHelper.extractEnhancementProperties(chainExProps, em, executionPlanNode, "Chain Execution");
            log.debug("> extract EnhancementProperties form the ExecutionNode of Engine {}", (Object)engine.getName());
            Iterator engineExecutions = em.filter(null, ExecutionPlan.ENGINE, (RDFTerm)new PlainLiteralImpl(engine.getName()));
            while (engineExecutions.hasNext()) {
                BlankNodeOrIRI engineExecution = ((Triple)engineExecutions.next()).getSubject();
                if (!em.contains((Object)new TripleImpl(executionPlanNode, ExecutionPlan.HAS_EXECUTION_NODE, (RDFTerm)engineExecution))) continue;
                EnhancementEngineHelper.extractEnhancementProperties(engineExProps, em, engineExecution, "Engine Execution");
            }
        }
        catch (NoSuchPartException e) {
            log.debug("  - no ExecutionMetadata are present ...");
        }
        finally {
            ci.getLock().readLock().unlock();
        }
        chainExProps.putAll(engineExProps);
        return chainExProps;
    }

    private static void extractEnhancementProperties(Map<String, Object> properties, Graph graph, BlankNodeOrIRI node, String level) {
        log.debug(" - extract {} properties from {}", (Object)level, (Object)node);
        Iterator props = graph.filter(node, null, null);
        while (props.hasNext()) {
            Triple t = (Triple)props.next();
            String propUri = t.getPredicate().getUnicodeString();
            if (!propUri.startsWith(EHPROP_NS)) continue;
            String prop = propUri.substring(EHPROP_NS_LENGTH);
            RDFTerm resource = t.getObject();
            Object value = EnhancementEngineHelper.extractEnhancementPropertyValue(resource);
            if (value == null || prop.isEmpty()) continue;
            Object current = properties.get(prop);
            if (log.isDebugEnabled()) {
                if (current != null) {
                    log.debug(" ... append {} property '{}' to {}='{}'", new Object[]{level, value, prop, current});
                } else {
                    log.debug(" ... add {} property {}='{}'", new Object[]{level, prop, value});
                }
            }
            if (current instanceof Collection) {
                ((Collection)current).add(value);
                continue;
            }
            if (current != null) {
                ArrayList<Object> col = new ArrayList<Object>(4);
                col.add(current);
                col.add(value);
                properties.put(prop, col);
                continue;
            }
            properties.put(prop, value);
        }
    }

    private static Object extractEnhancementPropertyValue(RDFTerm r) {
        String value = r instanceof IRI ? ((IRI)r).getUnicodeString() : (r instanceof Literal ? ((Literal)r).getLexicalForm() : null);
        return value;
    }

    public static <T> Collection<T> getConfigValues(Dictionary<String, Object> config, String property, Class<T> type) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("The parsed Dictionary with the configuration MUST NOT be NULL!");
        }
        if (property == null) {
            throw new NullPointerException("The parsed configuration property MUST NOT be NULL!");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(config.get(property), type);
        }
        catch (IllegalStateException e) {
            throw new ConfigurationException(property, e.getMessage(), (Throwable)e);
        }
    }

    public static <T> Collection<T> getConfigValues(EnhancementEngine ee, ContentItem ci, Map<String, Object> enhProps, String enhProp, Class<T> type) throws EnhancementPropertyException {
        if (enhProp == null) {
            throw new NullPointerException("The parsed EnhancementProperty MUST NOT be NULL");
        }
        if (enhProps == null) {
            throw new NullPointerException("The parsed Map with the EnhancementProperties MUST NOT be NULL");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(enhProps.get(enhProp), type);
        }
        catch (IllegalStateException e) {
            throw new EnhancementPropertyException(ee, ci, enhProp, e.getMessage(), e);
        }
    }

    public static <T> Collection<T> parseConfigValues(Object value, Class<T> type) {
        return EnhancementEngineHelper.parseConfigValues(value, type, false);
    }

    public static <T> Collection<T> getConfigValues(Dictionary<String, Object> config, String property, Class<T> type, boolean preserveNullValues) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("The parsed Dictionary with the configuration MUST NOT be NULL!");
        }
        if (property == null) {
            throw new NullPointerException("The parsed configuration property MUST NOT be NULL!");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(config.get(property), type, preserveNullValues);
        }
        catch (IllegalStateException e) {
            throw new ConfigurationException(property, e.getMessage(), (Throwable)e);
        }
    }

    public static <T> Collection<T> getConfigValues(EnhancementEngine ee, ContentItem ci, Map<String, Object> enhProps, String enhProp, Class<T> type, boolean preserveNullValues) throws EnhancementPropertyException {
        if (enhProp == null) {
            throw new NullPointerException("The parsed EnhancementProperty MUST NOT be NULL");
        }
        if (enhProps == null) {
            throw new NullPointerException("The parsed Map with the EnhancementProperties MUST NOT be NULL");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(enhProps.get(enhProp), type, preserveNullValues);
        }
        catch (IllegalStateException e) {
            throw new EnhancementPropertyException(ee, ci, enhProp, e.getMessage(), e);
        }
    }

    public static <T> Collection<T> parseConfigValues(Object value, Class<T> type, boolean preseveNullValues) {
        return EnhancementEngineHelper.parseConfigValues(value, type, null, preseveNullValues);
    }

    public static <T> Collection<T> getConfigValues(Dictionary<String, Object> config, String property, Class<T> type, Collection<T> configValues) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("The parsed Dictionary with the configuration MUST NOT be NULL!");
        }
        if (property == null) {
            throw new NullPointerException("The parsed configuration property MUST NOT be NULL!");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(config.get(property), type, configValues);
        }
        catch (IllegalStateException e) {
            throw new ConfigurationException(property, e.getMessage(), (Throwable)e);
        }
    }

    public static <T> Collection<T> getConfigValues(EnhancementEngine ee, ContentItem ci, Map<String, Object> enhProps, String enhProp, Class<T> type, Collection<T> configValues) throws EnhancementPropertyException {
        if (enhProp == null) {
            throw new NullPointerException("The parsed EnhancementProperty MUST NOT be NULL");
        }
        if (enhProps == null) {
            throw new NullPointerException("The parsed Map with the EnhancementProperties MUST NOT be NULL");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(enhProps.get(enhProp), type, configValues);
        }
        catch (IllegalStateException e) {
            throw new EnhancementPropertyException(ee, ci, enhProp, e.getMessage(), e);
        }
    }

    public static <T> Collection<T> parseConfigValues(Object value, Class<T> type, Collection<T> configValues) {
        return EnhancementEngineHelper.parseConfigValues(value, type, configValues, false);
    }

    public static <T> Collection<T> getConfigValues(Dictionary<String, Object> config, String property, Class<T> type, Collection<T> configValues, boolean preserveNullValues) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("The parsed Dictionary with the configuration MUST NOT be NULL!");
        }
        if (property == null) {
            throw new NullPointerException("The parsed configuration property MUST NOT be NULL!");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(config.get(property), type, configValues, preserveNullValues);
        }
        catch (IllegalStateException e) {
            throw new ConfigurationException(property, e.getMessage(), (Throwable)e);
        }
    }

    public static <T> Collection<T> getConfigValues(EnhancementEngine ee, ContentItem ci, Map<String, Object> enhProps, String enhProp, Class<T> type, Collection<T> configValues, boolean preserveNullValues) throws EnhancementPropertyException {
        if (enhProp == null) {
            throw new NullPointerException("The parsed EnhancementProperty MUST NOT be NULL");
        }
        if (enhProps == null) {
            throw new NullPointerException("The parsed Map with the EnhancementProperties MUST NOT be NULL");
        }
        try {
            return EnhancementEngineHelper.parseConfigValues(enhProps.get(enhProp), type, configValues, preserveNullValues);
        }
        catch (IllegalStateException e) {
            throw new EnhancementPropertyException(ee, ci, enhProp, e.getMessage(), e);
        }
    }

    public static <T> Collection<T> parseConfigValues(Object value, Class<T> type, Collection<T> configValues, boolean preseveNullValues) {
        Collection<Object> values;
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            values = (Set<Object>)value;
        } else if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int len = Array.getLength(value);
                ArrayList<Object> arrayList = new ArrayList<Object>(len);
                for (int i = 0; i < len; ++i) {
                    arrayList.add(Array.get(value, i));
                }
                values = arrayList;
            } else {
                values = Arrays.asList((Object[])value);
            }
        } else {
            values = Collections.singleton(value);
        }
        Constructor<T> constructor = EnhancementEngineHelper.getConfigTypeConstructor(type);
        if (configValues == null) {
            configValues = new ArrayList<T>(values.size());
        }
        for (Object e : values) {
            if (e == null) {
                if (!preseveNullValues) continue;
                configValues.add(null);
                continue;
            }
            configValues.add(EnhancementEngineHelper.parseConfigValue(e, type, constructor));
        }
        return configValues;
    }

    public static final <T> T getFirstConfigValue(Dictionary<String, Object> config, String property, Class<T> type) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("The parsed configuration MUST NOT be NULL!");
        }
        if (property == null) {
            throw new NullPointerException("The pased configuration property MUST NOT be NULL!");
        }
        try {
            return EnhancementEngineHelper.parseFirstConfigValue(config.get(property), type);
        }
        catch (IllegalStateException e) {
            throw new ConfigurationException(property, e.getMessage(), (Throwable)e);
        }
    }

    public static final <T> T getFirstConfigValue(EnhancementEngine ee, ContentItem ci, Map<String, Object> enhProps, String enhProp, Class<T> type) throws EnhancementPropertyException {
        if (enhProp == null) {
            throw new NullPointerException("The parsed EnhancementProperty MUST NOT be NULL");
        }
        if (enhProps == null) {
            throw new NullPointerException("The parsed Map with the EnhancementProperties MUST NOT be NULL");
        }
        try {
            return EnhancementEngineHelper.parseFirstConfigValue(enhProps.get(enhProp), type);
        }
        catch (IllegalStateException e) {
            throw new EnhancementPropertyException(ee, ci, enhProp, e.getMessage(), e);
        }
    }

    public static final <T> T parseFirstConfigValue(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        Object first = null;
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            if (c.isEmpty()) {
                return null;
            }
            Iterator it = c.iterator();
            while (first == null && it.hasNext()) {
                first = it.next();
            }
        } else if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            int len = Array.getLength(value);
            if (len < 1) {
                return null;
            }
            if (componentType.isPrimitive()) {
                first = Array.get(value, 0);
            } else {
                for (int i = 0; first == null && i < len; ++i) {
                    first = Array.get(value, i);
                }
            }
        } else {
            first = value;
        }
        return EnhancementEngineHelper.parseConfigValue(first, type, EnhancementEngineHelper.getConfigTypeConstructor(type));
    }

    private static <T> T parseConfigValue(Object value, Class<T> type, Constructor<T> constructor) {
        T configValue;
        if (value == null) {
            return null;
        }
        if (constructor == null) {
            configValue = type.cast(value.toString());
        } else {
            try {
                configValue = constructor.newInstance(value.toString());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to instantiate the parsed value type '" + type.getClass().getName() + "'!", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to access the constructor of the parsed value type '" + type.getClass().getName() + "'!", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Unable to instantiate the parsed value type '" + type.getClass().getName() + "' with the String value '" + value + "'!", e);
            }
        }
        return configValue;
    }

    private static <T> Constructor<T> getConfigTypeConstructor(Class<T> type) {
        Constructor<T> constructor;
        if (String.class.equals(type)) {
            constructor = null;
        } else {
            try {
                constructor = type.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Parsed config value type '" + type.getClass().getName() + "' does not define a Constructor " + "that takes a String as only parameter!", e);
            }
        }
        return constructor;
    }
}

