/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.stanboltools.datafileprovider.impl.tracking;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferenceStrategy;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileListener;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProvider;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileTracker;
import org.apache.stanbol.commons.stanboltools.datafileprovider.impl.tracking.DataFileReference;
import org.apache.stanbol.commons.stanboltools.datafileprovider.impl.tracking.STATE;
import org.apache.stanbol.commons.stanboltools.datafileprovider.impl.tracking.TrackingState;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true)
@Service
@Property(name="service.ranking", intValue={0x7FFFFFFF})
public final class DataFileTrackerImpl
implements DataFileTracker {
    protected final Logger log = LoggerFactory.getLogger(DataFileTrackerImpl.class);
    public static final long DEFAULT_INTERVAL = 5000L;
    private static final long MIN_INTERVAL = 500L;
    @Property(longValue={5000L})
    public static final String PROPERTY_TRACKING_INTERVAL = "data.files.tracking.interval";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC, strategy=ReferenceStrategy.EVENT, bind="bindDataFileProvider", unbind="unbindDataFileProvider")
    protected DataFileProvider _dataFileProvider;
    protected long interval;
    protected boolean active = false;
    private final Map<DataFileReference, TrackingState> trackedResources = Collections.synchronizedMap(new HashMap());

    protected DataFileProvider getDataFileProvider() {
        return this._dataFileProvider;
    }

    protected void bindDataFileProvider(DataFileProvider dfp) {
        this._dataFileProvider = dfp;
    }

    protected void unbindDataFileProvider(DataFileProvider dfp) {
        if (dfp != null && dfp.equals(this._dataFileProvider)) {
            this._dataFileProvider = null;
        }
    }

    public DataFileTrackerImpl() {
    }

    public DataFileTrackerImpl(DataFileProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The parsed DataFileProvider MUST NOT be NULL!");
        }
        this.bindDataFileProvider(provider);
    }

    @Activate
    protected void activate(ComponentContext context) {
        Object value = context.getProperties().get(PROPERTY_TRACKING_INTERVAL);
        if (value instanceof Number) {
            this.setInterval(((Number)value).longValue());
        } else if (value != null) {
            try {
                this.setInterval(new BigDecimal(value.toString()).longValue());
            }
            catch (NumberFormatException e) {
                this.log.warn("Value of property '" + value + "' can not be converted into a LONG", (Throwable)e);
            }
            catch (ArithmeticException e) {
                this.log.warn("Value of property '" + value + "' can not be converted into a LONG", (Throwable)e);
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.stopTracking();
        this.setInterval(5000L);
        this.trackedResources.clear();
    }

    public final long getInterval() {
        return this.interval;
    }

    public final void setInterval(long interval) {
        this.interval = interval <= 0L ? 5000L : (interval < 500L ? 500L : interval);
    }

    @Override
    public void add(DataFileListener resourceListener, String name, Map<String, String> properties) {
        this.add(resourceListener, null, name, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(DataFileListener resourceListener, String bundleSymbolicName, String name, Map<String, String> properties) {
        if (resourceListener == null) {
            throw new IllegalArgumentException("The parsed ResourceListener MUST NOT be NULL!");
        }
        DataFileReference r = new DataFileReference(bundleSymbolicName, name, properties);
        Map<DataFileReference, TrackingState> map = this.trackedResources;
        synchronized (map) {
            TrackingState trackingState = this.trackedResources.get(r);
            if (trackingState == null) {
                trackingState = new TrackingState();
                this.trackedResources.put(r, trackingState);
            }
            trackingState.addListener(resourceListener);
            if (!this.trackedResources.isEmpty()) {
                this.startTracking();
            }
        }
    }

    @Override
    public boolean isTracked(String bundleSymbolicName, String resourceName) {
        return this.trackedResources.containsKey(new DataFileReference(bundleSymbolicName, resourceName));
    }

    @Override
    public boolean isTracked(DataFileListener resourceListener, String bundleSymbolicName, String resourceName) {
        TrackingState state = this.trackedResources.get(new DataFileReference(bundleSymbolicName, resourceName));
        return state != null ? state.isListener(resourceListener) : false;
    }

    @Override
    public void remove(DataFileListener resourceListener, String resource) {
        this.remove(resourceListener, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(DataFileListener resourceListener, String bundleSymbolicName, String name) {
        if (resourceListener != null && name != null && !name.isEmpty()) {
            DataFileReference r = new DataFileReference(bundleSymbolicName, name);
            Map<DataFileReference, TrackingState> map = this.trackedResources;
            synchronized (map) {
                TrackingState state = this.trackedResources.get(r);
                if (state != null && state.removeListener(resourceListener) != null && state.isEmpty()) {
                    this.trackedResources.remove(r);
                }
                if (this.trackedResources.isEmpty()) {
                    this.stopTracking();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(DataFileListener resourceListener) {
        if (resourceListener != null) {
            Map<DataFileReference, TrackingState> map = this.trackedResources;
            synchronized (map) {
                Iterator<Map.Entry<DataFileReference, TrackingState>> entries = this.trackedResources.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<DataFileReference, TrackingState> entry = entries.next();
                    if (entry.getValue().removeListener(resourceListener) == null || !entry.getValue().isEmpty()) continue;
                    entries.remove();
                }
                if (this.trackedResources.isEmpty()) {
                    this.stopTracking();
                }
            }
        }
    }

    private void startTracking() {
        if (!this.active) {
            this.log.info("start Tracking ...");
            this.active = true;
            Thread t = new Thread((Runnable)new TrackingDaemon(), "DataFileTrackingDaemon");
            t.setDaemon(true);
            t.start();
        }
    }

    private void stopTracking() {
        this.active = false;
    }

    public void close() {
        this.deactivate(null);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected class TrackingDaemon
    implements Runnable {
        protected TrackingDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DataFileTrackerImpl.this.active) {
                HashSet resources;
                Map map = DataFileTrackerImpl.this.trackedResources;
                synchronized (map) {
                    resources = new HashSet(DataFileTrackerImpl.this.trackedResources.keySet());
                }
                DataFileProvider dataFileProvider = DataFileTrackerImpl.this.getDataFileProvider();
                if (dataFileProvider == null) {
                    DataFileTrackerImpl.this.log.info("Currently no DataFileProvider available");
                } else {
                    DataFileTrackerImpl.this.log.debug("Track {} resources", (Object)resources.size());
                    for (DataFileReference resoruce : resources) {
                        TrackingState resourceState;
                        Map map2 = DataFileTrackerImpl.this.trackedResources;
                        synchronized (map2) {
                            resourceState = (TrackingState)DataFileTrackerImpl.this.trackedResources.get(resoruce);
                        }
                        if (DataFileTrackerImpl.this.log.isDebugEnabled()) {
                            DataFileTrackerImpl.this.log.debug(" > {} (state:{})", (Object)resoruce.getName(), resourceState != null ? (resourceState.getTrackingState() != null ? resourceState.getTrackingState() : "none") : null);
                        }
                        if (resourceState == null) continue;
                        STATE state = dataFileProvider.isAvailable(resoruce.getBundleSymbolicName(), resoruce.getName(), resoruce.getProperties()) ? STATE.AVAILABLE : STATE.UNAVAILABLE;
                        this.fire(dataFileProvider, resoruce, resourceState, state);
                    }
                }
                try {
                    Thread.sleep(DataFileTrackerImpl.this.interval);
                }
                catch (InterruptedException e) {
                    DataFileTrackerImpl.this.log.debug("interrupped", (Throwable)e);
                }
            }
            DataFileTrackerImpl.this.log.info(" ... tracking stopped!");
        }

        private void fire(DataFileProvider dataFileProvider, DataFileReference resoruce, TrackingState trackinState, STATE state) {
            InputStream is = null;
            for (Map.Entry<DataFileListener, STATE> listenerState : trackinState) {
                if (listenerState.getValue() == state) continue;
                boolean remove = false;
                switch (state) {
                    case UNAVAILABLE: {
                        try {
                            remove = listenerState.getKey().unavailable(resoruce.getName());
                            trackinState.updateListener(listenerState.getKey(), state);
                        }
                        catch (Exception e) {
                            DataFileTrackerImpl.this.log.warn("Exception from Listener '" + listenerState.getKey() + "' while calling unavailable for resource '" + resoruce.getName() + "'!", (Throwable)e);
                            trackinState.updateListener(listenerState.getKey(), STATE.ERROR);
                        }
                        break;
                    }
                    case AVAILABLE: {
                        if (is == null) {
                            try {
                                is = dataFileProvider.getInputStream(resoruce.getBundleSymbolicName(), resoruce.getName(), resoruce.getProperties());
                            }
                            catch (IOException e) {
                                is = null;
                            }
                        }
                        try {
                            remove = listenerState.getKey().available(resoruce.getName(), is);
                            trackinState.updateListener(listenerState.getKey(), state);
                        }
                        catch (Exception e) {
                            DataFileTrackerImpl.this.log.warn("Exception from Listener '" + listenerState.getKey() + "' while calling available for resource '" + resoruce.getName() + "'!", (Throwable)e);
                            trackinState.updateListener(listenerState.getKey(), STATE.ERROR);
                        }
                        is = null;
                    }
                }
                if (!remove) continue;
                DataFileTrackerImpl.this.remove(listenerState.getKey(), resoruce.getBundleSymbolicName(), resoruce.getName());
            }
        }
    }
}

