/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.stanboltools.datafileprovider.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProvider;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProviderEvent;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProviderLog;
import org.apache.stanbol.commons.stanboltools.datafileprovider.impl.MainDataFileProvider;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="felix.webconsole.label", value={"stanbol_datafileprovider"}, propertyPrivate=true), @Property(name="felix.webconsole.title", value={"Stanbol Data File Provider"}, propertyPrivate=true)})
public class WebConsolePlugin
extends HttpServlet {
    @Reference
    private DataFileProviderLog dataFileProviderLog;
    @Reference
    private DataFileProvider dataFileProvider;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("<p class='statline ui-state-highlight'>");
        pw.println("Displaying the last " + this.dataFileProviderLog.size() + " DataFileProvider events");
        String dfPath = "<PATH NOT FOUND??>";
        if (this.dataFileProvider instanceof MainDataFileProvider) {
            dfPath = ((MainDataFileProvider)this.dataFileProvider).getDataFilesFolder().getAbsolutePath();
        }
        pw.println("<br/>");
        pw.println("Data files found in the " + dfPath + " folder have precedence");
        pw.println("<br/>");
        pw.println("The main DataFileProvider is " + this.dataFileProvider.getClass().getName());
        pw.println("</p>");
        pw.println("<table class='nicetable'>");
        String[] labels = new String[]{"timestamp", "bundle/filename", "actual location/download info"};
        pw.println("<thead><tr>");
        for (String label : labels) {
            WebConsolePlugin.cell("th", pw, null, label);
        }
        pw.println("</tr></thead><tbody>");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        for (DataFileProviderEvent e : this.dataFileProviderLog) {
            pw.println("<tr>");
            WebConsolePlugin.cell(pw, null, fmt.format(e.getTimestamp()));
            WebConsolePlugin.cell(pw, null, e.getBundleSymbolicName(), "b", e.getFilename());
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> comment : e.getComments().entrySet()) {
                if (sb.length() > 0) {
                    sb.append("<br/>");
                }
                sb.append((Object)comment.getKey());
                sb.append(": ");
                sb.append((Object)comment.getValue());
            }
            WebConsolePlugin.cell(pw, null, e.getActualFileLocation(), "i", sb.toString());
            pw.println("</tr>");
        }
        pw.println("</tbody></table>");
    }

    private static void cell(PrintWriter pw, String ... content) {
        WebConsolePlugin.cell("td", pw, content);
    }

    private static void cell(String tag, PrintWriter pw, String ... content) {
        pw.print("<");
        pw.print(tag);
        pw.print(">");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < content.length; i += 2) {
            String value;
            if (!first) {
                sb.append("<br/>\n");
            }
            if ((value = content[i + 1]) == null) continue;
            String lineTag = content[i];
            if (lineTag != null) {
                sb.append("<").append(lineTag).append(">");
            }
            sb.append(value);
            if (lineTag != null) {
                sb.append("</").append(lineTag).append(">");
            }
            first = false;
        }
        pw.print(sb.toString());
        pw.print("<");
        pw.print(tag);
        pw.print(">");
    }

    protected void bindDataFileProviderLog(DataFileProviderLog dataFileProviderLog) {
        this.dataFileProviderLog = dataFileProviderLog;
    }

    protected void unbindDataFileProviderLog(DataFileProviderLog dataFileProviderLog) {
        if (this.dataFileProviderLog == dataFileProviderLog) {
            this.dataFileProviderLog = null;
        }
    }

    protected void bindDataFileProvider(DataFileProvider dataFileProvider) {
        this.dataFileProvider = dataFileProvider;
    }

    protected void unbindDataFileProvider(DataFileProvider dataFileProvider) {
        if (this.dataFileProvider == dataFileProvider) {
            this.dataFileProvider = null;
        }
    }
}

