/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.stanboltools.datafileprovider.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProvider;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProviderEvent;
import org.apache.stanbol.commons.stanboltools.datafileprovider.DataFileProviderLog;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true)
@Service
@Property(name="service.ranking", intValue={0x7FFFFFFF})
public class MainDataFileProvider
implements DataFileProvider,
DataFileProviderLog {
    @Property(value={"datafiles"})
    public static final String DATA_FILES_FOLDER_PROP = "data.files.folder";
    @Property(intValue={100})
    public static final String MAX_EVENTS_PROP = "max.events";
    private static final Logger log = LoggerFactory.getLogger(MainDataFileProvider.class);
    private File dataFilesFolder;
    private int maxEvents;
    private final List<DataFileProviderEvent> events = new LinkedList<DataFileProviderEvent>();
    private ServiceTracker providersTracker;
    private boolean providersTrackerOpen = false;

    @Activate
    protected void activate(ComponentContext ctx) throws ConfigurationException {
        String folderName = MainDataFileProvider.requireProperty(ctx.getProperties(), DATA_FILES_FOLDER_PROP, String.class);
        String slingHome = ctx.getBundleContext().getProperty("sling.home");
        this.dataFilesFolder = slingHome != null ? new File(slingHome, folderName) : new File(folderName);
        if (!this.dataFilesFolder.exists()) {
            if (!this.dataFilesFolder.mkdirs()) {
                throw new ConfigurationException(DATA_FILES_FOLDER_PROP, "Unable to create the configured Directory " + this.dataFilesFolder);
            }
        } else if (!this.dataFilesFolder.isDirectory()) {
            throw new ConfigurationException(DATA_FILES_FOLDER_PROP, "The configured DataFile directory " + this.dataFilesFolder + " does already exists but is not a directory!");
        }
        this.maxEvents = MainDataFileProvider.requireProperty(ctx.getProperties(), MAX_EVENTS_PROP, Integer.class);
        this.providersTracker = new ServiceTracker(ctx.getBundleContext(), DataFileProvider.class.getName(), null);
        this.providersTrackerOpen = false;
        log.info("Activated, max.events {}, data files folder {}", (Object)this.maxEvents, (Object)this.dataFilesFolder.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        if (this.providersTracker != null) {
            ServiceTracker serviceTracker = this.providersTracker;
            synchronized (serviceTracker) {
                this.providersTrackerOpen = false;
                this.providersTracker.close();
            }
            this.providersTracker = null;
        }
    }

    static <ResultType> ResultType requireProperty(Dictionary<?, ?> props, String name, Class<ResultType> clazz) throws ConfigurationException {
        Object o = props.get(name);
        if (o == null) {
            throw new ConfigurationException(name, "Missing required configuration property: " + name);
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            throw new ConfigurationException(name, "Property is not a " + clazz.getName());
        }
        return (ResultType)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DataFileProviderEvent> iterator() {
        LinkedList<DataFileProviderEvent> copy = new LinkedList<DataFileProviderEvent>();
        List<DataFileProviderEvent> list = this.events;
        synchronized (list) {
            copy.addAll(this.events);
        }
        return copy.iterator();
    }

    @Override
    public int maxEventsCount() {
        return this.maxEvents;
    }

    @Override
    public int size() {
        return this.events.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(String bundleSymbolicName, String filename, Map<String, String> comments) throws IOException {
        InputStream result = null;
        String fileUrl = null;
        final File dataFile = this.getDataFile(bundleSymbolicName, filename);
        if (dataFile == null) {
            List<ServiceReference> refs = this.getSortedServiceRefs();
            for (ServiceReference ref : refs) {
                Object o = this.providersTracker.getService(ref);
                if (o == this) continue;
                DataFileProvider dfp = (DataFileProvider)o;
                try {
                    result = dfp.getInputStream(bundleSymbolicName, filename, comments);
                }
                catch (Exception e) {
                    log.debug(String.format("Eception while searching DataFile %s by using provider %s (ignore)", filename, dfp), (Throwable)e);
                }
                if (result == null) {
                    log.debug("{} does not provide file {}", (Object)dfp, (Object)filename);
                    continue;
                }
                fileUrl = dfp.getClass().getName() + "://" + filename;
                break;
            }
        } else {
            try {
                result = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return new FileInputStream(dataFile);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (RuntimeException)RuntimeException.class.cast(e);
            }
            fileUrl = dataFile.toURI().toASCIIString();
        }
        DataFileProviderEvent event = new DataFileProviderEvent(bundleSymbolicName, filename, comments, fileUrl);
        List<DataFileProviderEvent> list = this.events;
        synchronized (list) {
            if (this.events.size() >= this.maxEvents) {
                this.events.remove(0);
            }
            this.events.add(event);
        }
        if (result == null) {
            throw new IOException("File not found: " + filename);
        }
        log.debug("Successfully loaded file {}", (Object)event);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceReference> getSortedServiceRefs() {
        ServiceTracker providersTracker = this.providersTracker;
        if (providersTracker == null) {
            return Collections.emptyList();
        }
        if (!this.providersTrackerOpen) {
            ServiceTracker serviceTracker = providersTracker;
            synchronized (serviceTracker) {
                if (!this.providersTrackerOpen) {
                    providersTracker.open();
                }
            }
        }
        List<ServiceReference> refs = Arrays.asList(providersTracker.getServiceReferences());
        Collections.sort(refs);
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable(String bundleSymbolicName, String filename, Map<String, String> comments) {
        String fileUrl = null;
        File dataFile = this.getDataFile(bundleSymbolicName, filename);
        if (dataFile == null) {
            List<ServiceReference> refs = this.getSortedServiceRefs();
            Collections.sort(refs);
            for (ServiceReference ref : refs) {
                Object o = this.providersTracker.getService(ref);
                if (o == this) continue;
                DataFileProvider dfp = (DataFileProvider)o;
                try {
                    if (!dfp.isAvailable(bundleSymbolicName, filename, comments)) continue;
                    log.debug("{} does provide file {}", (Object)dfp, (Object)filename);
                    fileUrl = dfp.getClass().getName() + "://" + filename;
                    break;
                }
                catch (RuntimeException e) {
                    log.warn("Exception while checking availability of Datafile '{}' on DataFileProvider {}", (Object)filename, (Object)dfp);
                }
            }
        } else {
            log.debug("{} does provide file {}", (Object)this, (Object)filename);
            fileUrl = dataFile.toURI().toASCIIString();
        }
        DataFileProviderEvent event = new DataFileProviderEvent(bundleSymbolicName, filename, comments, fileUrl);
        List<DataFileProviderEvent> list = this.events;
        synchronized (list) {
            if (this.events.size() >= this.maxEvents) {
                this.events.remove(0);
            }
            this.events.add(event);
        }
        return fileUrl != null;
    }

    private File getDataFile(String bundleSymbolicName, final String filename) {
        String[] stringArray;
        if (bundleSymbolicName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = filename;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = bundleSymbolicName + "-" + filename;
            stringArray = stringArray3;
            stringArray3[1] = filename;
        }
        final String[] candidateNames = stringArray;
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                File dataFile = null;
                for (String name : candidateNames) {
                    dataFile = new File(MainDataFileProvider.this.dataFilesFolder, name);
                    log.debug("Looking for file {}", (Object)dataFile.getAbsolutePath());
                    if (dataFile.exists() && dataFile.canRead()) {
                        log.debug("File found in data files folder: {}", (Object)filename);
                        break;
                    }
                    dataFile = null;
                }
                return dataFile;
            }
        });
    }

    File getDataFilesFolder() {
        return this.dataFilesFolder;
    }
}

