/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.indexedgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.Language;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.AbstractGraph;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.stanbol.commons.indexedgraph.IndexedImmutableGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedGraph
extends AbstractGraph
implements Graph {
    private static final Logger log = LoggerFactory.getLogger(IndexedGraph.class);
    private final Map<Integer, List<RDFTerm>> hashCodeConflictMap = new HashMap<Integer, List<RDFTerm>>();
    private final Comparator<Triple> spoComparator = new Comparator<Triple>(){

        @Override
        public int compare(Triple a, Triple b) {
            int c = IndexedGraph.compare((RDFTerm)a.getSubject(), (RDFTerm)b.getSubject(), IndexedGraph.this.hashCodeConflictMap);
            if (c == 0 && (c = IndexedGraph.compare((RDFTerm)a.getPredicate(), (RDFTerm)b.getPredicate(), IndexedGraph.this.hashCodeConflictMap)) == 0) {
                c = IndexedGraph.compare(a.getObject(), b.getObject(), IndexedGraph.this.hashCodeConflictMap);
            }
            return c;
        }
    };
    private final NavigableSet<Triple> spo = new TreeSet<Triple>(this.spoComparator);
    private final Comparator<Triple> posComparator = new Comparator<Triple>(){

        @Override
        public int compare(Triple a, Triple b) {
            int c = IndexedGraph.compare((RDFTerm)a.getPredicate(), (RDFTerm)b.getPredicate(), IndexedGraph.this.hashCodeConflictMap);
            if (c == 0 && (c = IndexedGraph.compare(a.getObject(), b.getObject(), IndexedGraph.this.hashCodeConflictMap)) == 0) {
                c = IndexedGraph.compare((RDFTerm)a.getSubject(), (RDFTerm)b.getSubject(), IndexedGraph.this.hashCodeConflictMap);
            }
            return c;
        }
    };
    private final NavigableSet<Triple> pos = new TreeSet<Triple>(this.posComparator);
    private final Comparator<Triple> ospComparator = new Comparator<Triple>(){

        @Override
        public int compare(Triple a, Triple b) {
            int c = IndexedGraph.compare(a.getObject(), b.getObject(), IndexedGraph.this.hashCodeConflictMap);
            if (c == 0 && (c = IndexedGraph.compare((RDFTerm)a.getSubject(), (RDFTerm)b.getSubject(), IndexedGraph.this.hashCodeConflictMap)) == 0) {
                c = IndexedGraph.compare((RDFTerm)a.getPredicate(), (RDFTerm)b.getPredicate(), IndexedGraph.this.hashCodeConflictMap);
            }
            return c;
        }
    };
    private final NavigableSet<Triple> osp = new TreeSet<Triple>(this.ospComparator);
    protected static IRI MIN = new IRI(""){

        public int hashCode() {
            return Integer.MIN_VALUE;
        }
    };
    protected static IRI MAX = new IRI(""){

        public int hashCode() {
            return Integer.MAX_VALUE;
        }
    };

    public ImmutableGraph getImmutableGraph() {
        return new IndexedImmutableGraph(this);
    }

    public IndexedGraph() {
    }

    public IndexedGraph(Iterator<Triple> iterator) {
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            this.performAdd(triple);
        }
    }

    public IndexedGraph(Collection<Triple> baseCollection) {
        this.spo.addAll(baseCollection);
        this.pos.addAll(this.spo);
        this.osp.addAll(this.spo);
    }

    protected Iterator<Triple> performFilter(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        if (subject == null && predicate == null && object == null) {
            return this.createIterator(this.spo, this.spo.iterator());
        }
        TripleImpl low = new TripleImpl((BlankNodeOrIRI)(subject == null ? MIN : subject), predicate == null ? MIN : predicate, (RDFTerm)(object == null ? MIN : object));
        TripleImpl high = new TripleImpl((BlankNodeOrIRI)(subject == null ? MAX : subject), predicate == null ? MAX : predicate, (RDFTerm)(object == null ? MAX : object));
        if (subject != null && predicate != null && object != null) {
            return this.createIterator(this.spo, this.spo.subSet((Triple)low, true, (Triple)low, true).iterator());
        }
        if (subject != null && object == null) {
            return this.createIterator(this.spo, this.spo.subSet((Triple)low, (Triple)high).iterator());
        }
        if (predicate != null) {
            return this.createIterator(this.pos, this.pos.subSet((Triple)low, (Triple)high).iterator());
        }
        return this.createIterator(this.osp, this.osp.subSet((Triple)low, (Triple)high).iterator());
    }

    protected boolean performAdd(Triple triple) {
        if (this.spo.add(triple)) {
            this.osp.add(triple);
            return this.pos.add(triple);
        }
        return false;
    }

    protected boolean performRemove(Object t) {
        Triple triple;
        if (t instanceof Triple && this.spo.remove(triple = (Triple)t)) {
            this.osp.remove(triple);
            return this.pos.remove(triple);
        }
        return false;
    }

    public int performSize() {
        return this.spo.size();
    }

    private Iterator<Triple> createIterator(final SortedSet<Triple> index, final Iterator<Triple> base) {
        return new Iterator<Triple>(){
            Triple current = null;

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public Triple next() {
                this.current = (Triple)base.next();
                return this.current;
            }

            @Override
            public void remove() {
                base.remove();
                if (this.current != null) {
                    if (index != IndexedGraph.this.spo) {
                        IndexedGraph.this.spo.remove(this.current);
                    }
                    if (index != IndexedGraph.this.pos) {
                        IndexedGraph.this.pos.remove(this.current);
                    }
                    if (index != IndexedGraph.this.osp) {
                        IndexedGraph.this.osp.remove(this.current);
                    }
                }
            }
        };
    }

    private static int resolveBlankNodeHashConflict(RDFTerm a, RDFTerm b, Map<Integer, List<RDFTerm>> confictsMap) {
        Integer hash = a.hashCode();
        List<RDFTerm> resources = confictsMap.get(hash);
        if (resources == null) {
            resources = new ArrayList<RDFTerm>(2);
            confictsMap.put(hash, resources);
            resources.add(a);
            resources.add(b);
            return -1;
        }
        int aIndex = -1;
        int bIndex = -1;
        for (int i = 0; i < resources.size() && (aIndex < 0 || bIndex < 0); ++i) {
            RDFTerm r = resources.get(i);
            if (aIndex < 0 && r.equals(a)) {
                aIndex = i;
            }
            if (bIndex >= 0 || !r.equals(b)) continue;
            bIndex = i;
        }
        if (aIndex < 0) {
            aIndex = resources.size();
            resources.add(a);
        }
        if (bIndex < 0) {
            bIndex = resources.size();
            resources.add(b);
        }
        return aIndex < bIndex ? -1 : 1;
    }

    protected static int compare(RDFTerm a, RDFTerm b, Map<Integer, List<RDFTerm>> confictsMap) {
        int bt;
        int at;
        if (a == MIN || b == MAX) {
            return -1;
        }
        if (a == MAX || b == MIN) {
            return 1;
        }
        int n = a instanceof IRI ? 0 : (at = a instanceof Literal ? 1 : 2);
        int n2 = b instanceof IRI ? 0 : (bt = b instanceof Literal ? 1 : 2);
        if (at == bt) {
            int bh;
            if (at < 2) {
                String bs;
                String as = at == 0 ? ((IRI)a).getUnicodeString() : ((Literal)a).getLexicalForm();
                int sc = as.compareTo(bs = bt == 0 ? ((IRI)b).getUnicodeString() : ((Literal)b).getLexicalForm());
                if (sc == 0 && at == 1) {
                    Language bl;
                    Language al = a instanceof Literal ? ((Literal)a).getLanguage() : null;
                    Language language = bl = b instanceof Literal ? ((Literal)b).getLanguage() : null;
                    sc = al == null ? (bl == null ? 0 : -1) : (bl == null ? 1 : al.toString().compareTo(bl.toString()));
                    if (sc == 0) {
                        IRI bdt;
                        IRI adt = a instanceof Literal ? ((Literal)a).getDataType() : null;
                        IRI iRI = bdt = b instanceof Literal ? ((Literal)b).getDataType() : null;
                        sc = adt == null ? (bdt == null ? 0 : -1) : (bdt == null ? 1 : adt.getUnicodeString().compareTo(bdt.getUnicodeString()));
                    }
                    return sc;
                }
                return sc;
            }
            int ah = a.hashCode();
            if (ah == (bh = b.hashCode())) {
                if (!a.equals(b)) {
                    int bsh;
                    int ash = System.identityHashCode(a);
                    if (ash == (bsh = System.identityHashCode(b))) {
                        return IndexedGraph.resolveBlankNodeHashConflict(a, b, confictsMap);
                    }
                    return ash < bsh ? -1 : 1;
                }
                return 0;
            }
            return ah < bh ? -1 : 1;
        }
        return at < bt ? -1 : 1;
    }
}

