/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server.helper;

import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;

public abstract class ServerEventListenerHelper
implements NamedResource {
    private final String name;
    private final Appendable stdout;
    private final Appendable stderr;

    public ServerEventListenerHelper(String name, Appendable stdout, Appendable stderr) {
        this.name = name;
        this.stdout = Objects.requireNonNull(stdout, "No output target");
        this.stderr = Objects.requireNonNull(stderr, "No error target");
    }

    public String getName() {
        return this.name;
    }

    public Appendable getStdout() {
        return this.stdout;
    }

    public Appendable getStderr() {
        return this.stderr;
    }

    protected String outputErrorMessage(String format, Object ... args) throws IOException {
        return this.outputMessage(this.getStderr(), format, args);
    }

    protected String outputDebugMessage(String format, Object ... args) throws IOException {
        return this.outputMessage(this.getStdout(), format, args);
    }

    protected String outputMessage(Appendable out, String format, Object ... args) throws IOException {
        String message = String.format(format, args);
        out.append(this.getName()).append(": ").append(message).append(System.lineSeparator());
        if (out instanceof Flushable) {
            ((Flushable)((Object)out)).flush();
        }
        return message;
    }
}

