/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import org.apache.sshd.cli.CliSupport;
import org.apache.sshd.cli.client.SshClientCliSupport;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.PtyChannelConfiguration;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseOutputStream;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SshClientMain
extends SshClientCliSupport {
    protected SshClientMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block82: {
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            boolean agentForward = false;
            ArrayList<String> command = null;
            int socksPort = -1;
            int numArgs = GenericUtils.length((Object[])args);
            boolean error = false;
            String target = null;
            Level level = Level.WARNING;
            OutputStream logStream = stderr;
            for (int i = 0; i < numArgs; ++i) {
                String argName = args[i];
                if (GenericUtils.isEmpty(command) && SshClientMain.isArgumentedOption("-p", argName)) {
                    if (i + 1 >= numArgs) {
                        error = SshClientMain.showError(stderr, "option requires an argument: " + argName);
                        break;
                    }
                    ++i;
                    continue;
                }
                if (GenericUtils.isEmpty(command) && ("-v".equals(argName) || "-vv".equals(argName) || "-vvv".equals(argName))) continue;
                if (GenericUtils.isEmpty(command) && "-D".equals(argName)) {
                    if (i + 1 >= numArgs) {
                        error = SshClientMain.showError(stderr, "option requires an argument: " + argName);
                        break;
                    }
                    if (socksPort > 0) {
                        error = SshClientMain.showError(stderr, argName + " option value re-specified: " + socksPort);
                        break;
                    }
                    if ((socksPort = Integer.parseInt(args[++i])) > 0) continue;
                    error = SshClientMain.showError(stderr, "Bad option value for " + argName + ": " + socksPort);
                    break;
                }
                if (GenericUtils.isEmpty(command) && "-A".equals(argName)) {
                    agentForward = true;
                    continue;
                }
                if (GenericUtils.isEmpty(command) && "-a".equals(argName)) {
                    agentForward = false;
                    continue;
                }
                level = CliSupport.resolveLoggingVerbosity(args, i);
                logStream = SshClientMain.resolveLoggingTargetStream(stdout, stderr, args, i);
                if (logStream == null) {
                    error = true;
                    break;
                }
                if (GenericUtils.isEmpty(command) && target == null) {
                    target = argName;
                    continue;
                }
                if (command == null) {
                    command = new ArrayList<String>();
                }
                command.add(argName);
            }
            ClientSession session = null;
            try (BufferedReader stdin = new BufferedReader(new InputStreamReader((InputStream)new NoCloseInputStream(System.in), Charset.defaultCharset()));){
                if (!error) {
                    SshClientMain.setupLogging(level, stdout, stderr, logStream);
                    session = SshClientMain.setupClientSession("-p", stdin, level, stdout, stderr, args);
                    if (session == null) {
                        error = true;
                    }
                }
                if (error) {
                    System.err.println("usage: ssh [-A|-a] [-v[v][v]] [-E logoutputfile] [-D socksPort] [-l login] [-p port] [-o option=value] [-w password] [-c cipherslist] [-m maclist] [-C] hostname/user@host [command]");
                    System.exit(-1);
                    return;
                }
                try (SshClient client = (SshClient)session.getFactoryManager();){
                    try {
                        ChannelShell channel;
                        if (socksPort >= 0) {
                            session.startDynamicPortForwarding(new SshdSocketAddress("localhost", socksPort));
                            Thread.sleep(Long.MAX_VALUE);
                            break block82;
                        }
                        Map<String, ?> env = SshClientMain.resolveClientEnvironment((PropertyResolver)client);
                        PtyChannelConfiguration ptyConfig = SshClientMain.resolveClientPtyOptions((PropertyResolver)client);
                        if (GenericUtils.isEmpty(command)) {
                            channel = session.createShellChannel((PtyChannelConfigurationHolder)ptyConfig, env);
                            channel.setAgentForwarding(agentForward);
                            channel.setIn((InputStream)new NoCloseInputStream(System.in));
                        } else {
                            channel = session.createExecChannel(String.join((CharSequence)" ", command).trim(), (PtyChannelConfigurationHolder)ptyConfig, env);
                        }
                        try (NoCloseOutputStream channelOut = new NoCloseOutputStream((OutputStream)System.out);
                             NoCloseOutputStream channelErr = new NoCloseOutputStream((OutputStream)System.err);){
                            channel.setOut((OutputStream)channelOut);
                            channel.setErr((OutputStream)channelErr);
                            channel.open().await();
                            channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                        }
                        finally {
                            channel.close();
                        }
                        session.close(false);
                    }
                    finally {
                        client.stop();
                    }
                }
                finally {
                    session.close();
                }
            }
            finally {
                if (logStream != null && logStream != stdout && logStream != stderr) {
                    logStream.close();
                }
            }
        }
    }
}

