/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class UIUtils$ {
    public static UIUtils$ MODULE$;
    private final ThreadLocal<SimpleDateFormat> batchTimeFormat;
    private final ThreadLocal<SimpleDateFormat> batchTimeFormatWithMilliseconds;

    static {
        new UIUtils$();
    }

    public String shortTimeUnitString(TimeUnit unit) {
        String string;
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            string = "ns";
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            string = "us";
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            string = "ms";
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            string = "sec";
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            string = "min";
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            string = "hrs";
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            string = "days";
        } else {
            throw new MatchError((Object)timeUnit);
        }
        return string;
    }

    public Tuple2<Object, TimeUnit> normalizeDuration(long milliseconds) {
        if (milliseconds < 1000L) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)milliseconds), (Object)TimeUnit.MILLISECONDS);
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)seconds), (Object)TimeUnit.SECONDS);
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)minutes), (Object)TimeUnit.MINUTES);
        }
        double hours = minutes / (double)60;
        if (hours < (double)24) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)hours), (Object)TimeUnit.HOURS);
        }
        double days = hours / (double)24;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)days), (Object)TimeUnit.DAYS);
    }

    public double convertToTimeUnit(long milliseconds, TimeUnit unit) {
        double d;
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            d = milliseconds * 1000L * 1000L;
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            d = milliseconds * 1000L;
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            d = milliseconds;
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0;
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0 / 60.0;
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0 / 60.0 / 60.0;
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            d = (double)milliseconds / 1000.0 / 60.0 / 60.0 / 24.0;
        } else {
            throw new MatchError((Object)timeUnit);
        }
        return d;
    }

    private ThreadLocal<SimpleDateFormat> batchTimeFormat() {
        return this.batchTimeFormat;
    }

    private ThreadLocal<SimpleDateFormat> batchTimeFormatWithMilliseconds() {
        return this.batchTimeFormatWithMilliseconds;
    }

    public String formatBatchTime(long batchTime, long batchInterval, boolean showYYYYMMSS, TimeZone timezone) {
        String string;
        Tuple2 oldTimezones = new Tuple2((Object)((DateFormat)this.batchTimeFormat().get()).getTimeZone(), (Object)((DateFormat)this.batchTimeFormatWithMilliseconds().get()).getTimeZone());
        if (timezone != null) {
            ((DateFormat)this.batchTimeFormat().get()).setTimeZone(timezone);
            ((DateFormat)this.batchTimeFormatWithMilliseconds().get()).setTimeZone(timezone);
        }
        try {
            String formattedBatchTime;
            String string2 = formattedBatchTime = batchInterval < 1000L ? ((Format)this.batchTimeFormatWithMilliseconds().get()).format(BoxesRunTime.boxToLong((long)batchTime)) : ((Format)this.batchTimeFormat().get()).format(BoxesRunTime.boxToLong((long)batchTime));
            string = showYYYYMMSS ? formattedBatchTime : formattedBatchTime.substring(formattedBatchTime.indexOf(32) + 1);
        }
        finally {
            if (timezone != null) {
                ((DateFormat)this.batchTimeFormat().get()).setTimeZone((TimeZone)oldTimezones._1());
                ((DateFormat)this.batchTimeFormatWithMilliseconds().get()).setTimeZone((TimeZone)oldTimezones._2());
            }
        }
        return string;
    }

    public boolean formatBatchTime$default$3() {
        return true;
    }

    public TimeZone formatBatchTime$default$4() {
        return null;
    }

    public String createOutputOperationFailureForUI(String failure) {
        String string;
        if (failure.startsWith("org.apache.spark.Spark")) {
            string = new StringBuilder(30).append("Failed due to Spark job error\n").append(failure).toString();
        } else {
            int nextLineIndex = failure.indexOf("\n");
            if (nextLineIndex < 0) {
                nextLineIndex = failure.length();
            }
            String firstLine = failure.substring(0, nextLineIndex);
            string = new StringBuilder(22).append("Failed due to error: ").append(firstLine).append("\n").append(failure).toString();
        }
        return string;
    }

    public Seq<Node> failureReasonCell(String failureReason, int rowspan, boolean includeFirstLineInExpandDetails) {
        Elem elem;
        String details;
        Object object;
        String failureDetails;
        boolean isMultiline = failureReason.indexOf(10) >= 0;
        String failureReasonSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? failureReason.substring(0, failureReason.indexOf(10)) : failureReason));
        String string = failureDetails = isMultiline && !includeFirstLineInExpandDetails ? failureReason.substring(failureReason.indexOf(10) + 1) : failureReason;
        if (isMultiline) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("expand-details"), (MetaData)$md);
            $md = new UnprefixedAttribute("onclick", (Seq)new Text("this.parentNode.querySelector('.stacktrace-details').classList.toggle('collapsed')"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        +details\n      "));
            Elem elem2 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("stacktrace-details collapsed"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)failureDetails);
            $buf2.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n        "));
            object = elem2.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2), NodeSeq$.MODULE$.canBuildFrom());
        } else {
            object = details = "";
        }
        if (rowspan == 1) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            Elem elem3 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem3;
        } else {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)rowspan)).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem4 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            elem = elem4;
        }
        return elem;
    }

    public int failureReasonCell$default$2() {
        return 1;
    }

    public boolean failureReasonCell$default$3() {
        return true;
    }

    private UIUtils$() {
        MODULE$ = this;
        this.batchTimeFormat = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US);
            }
        };
        this.batchTimeFormatWithMilliseconds = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
            }
        };
    }
}

