/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.python.PythonDStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.scheduler.ErrorReported;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager$;
import org.apache.spark.streaming.scheduler.InputInfoTracker;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobCompleted;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.JobScheduler$;
import org.apache.spark.streaming.scheduler.JobSchedulerEvent;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobStarted;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tUb!B\u00193\u0001Qb\u0004\u0002C%\u0001\u0005\u000b\u0007I\u0011A&\t\u0011A\u0003!\u0011!Q\u0001\n1CQ!\u0015\u0001\u0005\u0002ICqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004g\u0001\u0001\u0006I\u0001\u0017\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019a\u0007\u0001)A\u0005S\"9Q\u000e\u0001b\u0001\n\u0013q\u0007BB;\u0001A\u0003%q\u000eC\u0004w\u0001\t\u0007I\u0011B<\t\rm\u0004\u0001\u0015!\u0003y\u0011\u001da\bA1A\u0005\u0002uDq!a\u0002\u0001A\u0003%a\u0010C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\f!A\u00111\u0003\u0001!\u0002\u0013\ti\u0001C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0001\u0002\u0018!I\u0011q\u0004\u0001A\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u001a!I\u0011q\u0006\u0001A\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003s\u0001\u0001\u0019!C\u0001\u0003wA\u0001\"a\u0010\u0001A\u0003&\u00111\u0007\u0005\n\u0003\u0003\u0002\u0001\u0019!C\u0005\u0003\u0007B\u0011\"!\u0015\u0001\u0001\u0004%I!a\u0015\t\u0011\u0005]\u0003\u0001)Q\u0005\u0003\u000bB\u0011\"!\u0017\u0001\u0001\u0004%I!a\u0017\t\u0013\u0005%\u0004\u00011A\u0005\n\u0005-\u0004\u0002CA8\u0001\u0001\u0006K!!\u0018\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!3\u0001\t\u0003\tY\rC\u0004\u0002N\u0002!I!a4\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u0011Q\u001e\u0001\u0005\n\u0005=\bbBA|\u0001\u0011%\u0011\u0011 \u0004\u0007\u0003\u007f\u0004AA!\u0001\t\u0015\u0005mgE!A!\u0002\u0013\ti\u000e\u0003\u0004RM\u0011\u0005!Q\u0003\u0005\b\u0005;1C\u0011AA:\u000f!\u0011yB\rE\u0001i\t\u0005baB\u00193\u0011\u0003!$1\u0005\u0005\u0007#.\"\tA!\n\t\u0013\t\u001d2F1A\u0005\u0002\t%\u0002\u0002\u0003B\u0018W\u0001\u0006IAa\u000b\t\u0013\tE2F1A\u0005\u0002\t%\u0002\u0002\u0003B\u001aW\u0001\u0006IAa\u000b\u0003\u0019){'mU2iK\u0012,H.\u001a:\u000b\u0005M\"\u0014!C:dQ\u0016$W\u000f\\3s\u0015\t)d'A\u0005tiJ,\u0017-\\5oO*\u0011q\u0007O\u0001\u0006gB\f'o\u001b\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014xmE\u0002\u0001{\r\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0007C\u0001#H\u001b\u0005)%B\u0001$7\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001%F\u0005\u001daunZ4j]\u001e\f1a]:d\u0007\u0001)\u0012\u0001\u0014\t\u0003\u001b:k\u0011\u0001N\u0005\u0003\u001fR\u0012\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0002\tM\u001c8\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M+\u0006C\u0001+\u0001\u001b\u0005\u0011\u0004\"B%\u0004\u0001\u0004a\u0015a\u00026pEN+Go]\u000b\u00021B!\u0011L\u00181d\u001b\u0005Q&BA.]\u0003\u0011)H/\u001b7\u000b\u0003u\u000bAA[1wC&\u0011qL\u0017\u0002\u0004\u001b\u0006\u0004\bCA'b\u0013\t\u0011GG\u0001\u0003US6,\u0007C\u0001+e\u0013\t)'G\u0001\u0004K_\n\u001cV\r^\u0001\tU>\u00147+\u001a;tA\u0005\tb.^7D_:\u001cWO\u001d:f]RTuNY:\u0016\u0003%\u0004\"A\u00106\n\u0005-|$aA%oi\u0006\u0011b.^7D_:\u001cWO\u001d:f]RTuNY:!\u0003-QwNY#yK\u000e,Ho\u001c:\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A\u001d.\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002uc\n\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u00031QwNY#yK\u000e,Ho\u001c:!\u00031QwNY$f]\u0016\u0014\u0018\r^8s+\u0005A\bC\u0001+z\u0013\tQ(G\u0001\u0007K_\n<UM\\3sCR|'/A\u0007k_\n<UM\\3sCR|'\u000fI\u0001\u0006G2|7m[\u000b\u0002}B\u0019q0a\u0001\u000e\u0005\u0005\u0005!BA.7\u0013\u0011\t)!!\u0001\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003-a\u0017n\u001d;f]\u0016\u0014()^:\u0016\u0005\u00055\u0001c\u0001+\u0002\u0010%\u0019\u0011\u0011\u0003\u001a\u0003)M#(/Z1nS:<G*[:uK:,'OQ;t\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u0003=\u0011XmY3jm\u0016\u0014HK]1dW\u0016\u0014XCAA\r!\r!\u00161D\u0005\u0004\u0003;\u0011$a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u0002'I,7-Z5wKJ$&/Y2lKJ|F%Z9\u0015\t\u0005\r\u0012\u0011\u0006\t\u0004}\u0005\u0015\u0012bAA\u0014\u007f\t!QK\\5u\u0011%\tY#EA\u0001\u0002\u0004\tI\"A\u0002yIE\n\u0001C]3dK&4XM\u001d+sC\u000e\\WM\u001d\u0011\u0002!%t\u0007/\u001e;J]\u001a|GK]1dW\u0016\u0014XCAA\u001a!\r!\u0016QG\u0005\u0004\u0003o\u0011$\u0001E%oaV$\u0018J\u001c4p)J\f7m[3s\u0003QIg\u000e];u\u0013:4w\u000e\u0016:bG.,'o\u0018\u0013fcR!\u00111EA\u001f\u0011%\tY\u0003FA\u0001\u0002\u0004\t\u0019$A\tj]B,H/\u00138g_R\u0013\u0018mY6fe\u0002\n\u0011$\u001a=fGV$xN]!mY>\u001c\u0017\r^5p]6\u000bg.Y4feV\u0011\u0011Q\t\t\u0006}\u0005\u001d\u00131J\u0005\u0004\u0003\u0013z$AB(qi&|g\u000eE\u0002U\u0003\u001bJ1!a\u00143\u0005e)\u00050Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0002;\u0015DXmY;u_J\fE\u000e\\8dCRLwN\\'b]\u0006<WM]0%KF$B!a\t\u0002V!I\u00111F\f\u0002\u0002\u0003\u0007\u0011QI\u0001\u001bKb,7-\u001e;pe\u0006cGn\\2bi&|g.T1oC\u001e,'\u000fI\u0001\nKZ,g\u000e\u001e'p_B,\"!!\u0018\u0011\u000b}\fy&a\u0019\n\t\u0005\u0005\u0014\u0011\u0001\u0002\n\u000bZ,g\u000e\u001e'p_B\u00042\u0001VA3\u0013\r\t9G\r\u0002\u0012\u0015>\u00147k\u00195fIVdWM]#wK:$\u0018!D3wK:$Hj\\8q?\u0012*\u0017\u000f\u0006\u0003\u0002$\u00055\u0004\"CA\u00165\u0005\u0005\t\u0019AA/\u0003))g/\u001a8u\u0019>|\u0007\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003G\tAa\u001d;paR!\u00111EA=\u0011\u001d\tY(\ba\u0001\u0003{\na\u0003\u001d:pG\u0016\u001c8/\u00117m%\u0016\u001cW-\u001b<fI\u0012\u000bG/\u0019\t\u0004}\u0005}\u0014bAAA\u007f\t9!i\\8mK\u0006t\u0017\u0001D:vE6LGOS8c'\u0016$H\u0003BA\u0012\u0003\u000fCa!!#\u001f\u0001\u0004\u0019\u0017A\u00026pEN+G/A\bhKR\u0004VM\u001c3j]\u001e$\u0016.\\3t)\t\ty\tE\u0003\u0002\u0012\u0006\u0005\u0006M\u0004\u0003\u0002\u0014\u0006ue\u0002BAK\u00037k!!a&\u000b\u0007\u0005e%*\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0019\u0011qT \u0002\u000fA\f7m[1hK&!\u00111UAS\u0005\r\u0019V-\u001d\u0006\u0004\u0003?{\u0014a\u0003:fa>\u0014H/\u0012:s_J$b!a\t\u0002,\u0006}\u0006bBAWA\u0001\u0007\u0011qV\u0001\u0004[N<\u0007\u0003BAY\u0003ssA!a-\u00026B\u0019\u0011QS \n\u0007\u0005]v(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003w\u000biL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003o{\u0004bBAaA\u0001\u0007\u00111Y\u0001\u0002KB!\u0011\u0011SAc\u0013\u0011\t9-!*\u0003\u0013QC'o\\<bE2,\u0017!C5t'R\f'\u000f^3e)\t\ti(\u0001\u0007qe>\u001cWm]:Fm\u0016tG\u000f\u0006\u0003\u0002$\u0005E\u0007bBAjE\u0001\u0007\u00111M\u0001\u0006KZ,g\u000e^\u0001\u000fQ\u0006tG\r\\3K_\n\u001cF/\u0019:u)\u0019\t\u0019#!7\u0002d\"9\u00111\\\u0012A\u0002\u0005u\u0017a\u00016pEB\u0019A+a8\n\u0007\u0005\u0005(GA\u0002K_\nDq!!:$\u0001\u0004\t9/A\u0005ti\u0006\u0014H\u000fV5nKB\u0019a(!;\n\u0007\u0005-xH\u0001\u0003M_:<\u0017a\u00055b]\u0012dWMS8c\u0007>l\u0007\u000f\\3uS>tGCBA\u0012\u0003c\f\u0019\u0010C\u0004\u0002\\\u0012\u0002\r!!8\t\u000f\u0005UH\u00051\u0001\u0002h\u0006i1m\\7qY\u0016$X\r\u001a+j[\u0016\f1\u0002[1oI2,WI\u001d:peR1\u00111EA~\u0003{Dq!!,&\u0001\u0004\ty\u000bC\u0004\u0002B\u0016\u0002\r!a1\u0003\u0015){'\rS1oI2,'o\u0005\u0004'\u0005\u0007\u0011ya\u0011\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)\u0019!\u0011\u0002/\u0002\t1\fgnZ\u0005\u0005\u0005\u001b\u00119A\u0001\u0004PE*,7\r\u001e\t\u0005\u0005\u000b\u0011\t\"\u0003\u0003\u0003\u0014\t\u001d!\u0001\u0003*v]:\f'\r\\3\u0015\t\t]!1\u0004\t\u0004\u000531S\"\u0001\u0001\t\u000f\u0005m\u0007\u00061\u0001\u0002^\u0006\u0019!/\u001e8\u0002\u0019){'mU2iK\u0012,H.\u001a:\u0011\u0005Q[3CA\u0016>)\t\u0011\t#A\fC\u0003R\u001b\u0005j\u0018+J\u001b\u0016{\u0006KU(Q\u000bJ#\u0016lX&F3V\u0011!1\u0006\t\u0005\u0005\u000b\u0011i#\u0003\u0003\u0002<\n\u001d\u0011\u0001\u0007\"B)\u000eCu\fV%N\u000b~\u0003&k\u0014)F%RKvlS#ZA\u0005Ir*\u0016+Q+R{v\nU0J\t~\u0003&k\u0014)F%RKvlS#Z\u0003iyU\u000b\u0016)V)~{\u0005kX%E?B\u0013v\nU#S)f{6*R-!\u0001")
public class JobScheduler
implements Logging {
    private final StreamingContext ssc;
    private final Map<Time, JobSet> jobSets;
    private final int numConcurrentJobs;
    private final ThreadPoolExecutor jobExecutor;
    private final JobGenerator jobGenerator;
    private final Clock clock;
    private final StreamingListenerBus listenerBus;
    private ReceiverTracker receiverTracker;
    private InputInfoTracker inputInfoTracker;
    private Option<ExecutorAllocationManager> executorAllocationManager;
    private EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String OUTPUT_OP_ID_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY();
    }

    public static String BATCH_TIME_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    private Map<Time, JobSet> jobSets() {
        return this.jobSets;
    }

    private int numConcurrentJobs() {
        return this.numConcurrentJobs;
    }

    private ThreadPoolExecutor jobExecutor() {
        return this.jobExecutor;
    }

    private JobGenerator jobGenerator() {
        return this.jobGenerator;
    }

    public Clock clock() {
        return this.clock;
    }

    public StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker receiverTracker() {
        return this.receiverTracker;
    }

    public void receiverTracker_$eq(ReceiverTracker x$1) {
        this.receiverTracker = x$1;
    }

    public InputInfoTracker inputInfoTracker() {
        return this.inputInfoTracker;
    }

    public void inputInfoTracker_$eq(InputInfoTracker x$1) {
        this.inputInfoTracker = x$1;
    }

    private Option<ExecutorAllocationManager> executorAllocationManager() {
        return this.executorAllocationManager;
    }

    private void executorAllocationManager_$eq(Option<ExecutorAllocationManager> x$1) {
        this.executorAllocationManager = x$1;
    }

    public EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    }

    private void org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(EventLoop<JobSchedulerEvent> x$1) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = x$1;
    }

    public synchronized void start() {
        ExecutorAllocationClient executorAllocationClient;
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() != null) {
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting JobScheduler");
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(new EventLoop<JobSchedulerEvent>(this){
            private final /* synthetic */ JobScheduler $outer;

            public void onReceive(JobSchedulerEvent event) {
                this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(event);
            }

            public void onError(Throwable e) {
                this.$outer.reportError("Error in job scheduler", e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("JobScheduler");
            }
        });
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().start();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getInputStreams())).foreach((Function1 & Serializable & scala.Serializable)inputDStream -> {
            JobScheduler.$anonfun$start$2(this, inputDStream);
            return BoxedUnit.UNIT;
        });
        this.listenerBus().start();
        this.receiverTracker_$eq(new ReceiverTracker(this.ssc(), ReceiverTracker$.MODULE$.$lessinit$greater$default$2()));
        this.inputInfoTracker_$eq(new InputInfoTracker(this.ssc()));
        SchedulerBackend schedulerBackend = this.ssc().sparkContext().schedulerBackend();
        if (schedulerBackend instanceof ExecutorAllocationClient) {
            SchedulerBackend schedulerBackend2 = schedulerBackend;
            executorAllocationClient = (ExecutorAllocationClient)schedulerBackend2;
        } else {
            executorAllocationClient = null;
        }
        ExecutorAllocationClient executorAllocClient = executorAllocationClient;
        this.executorAllocationManager_$eq(ExecutorAllocationManager$.MODULE$.createIfEnabled(executorAllocClient, this.receiverTracker(), this.ssc().conf(), this.ssc().graph().batchDuration().milliseconds(), this.clock()));
        this.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)streamingListener -> {
            JobScheduler.$anonfun$start$4(this, streamingListener);
            return BoxedUnit.UNIT;
        });
        this.receiverTracker().start();
        this.jobGenerator().start();
        this.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started JobScheduler");
    }

    public synchronized void stop(boolean processAllReceivedData) {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping JobScheduler");
        if (this.receiverTracker() != null) {
            this.receiverTracker().stop(processAllReceivedData);
        }
        if (this.executorAllocationManager() != null) {
            this.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.stop();
                return BoxedUnit.UNIT;
            });
        }
        this.jobGenerator().stop(processAllReceivedData);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping job executor");
        this.jobExecutor().shutdown();
        boolean terminated = processAllReceivedData ? this.jobExecutor().awaitTermination(1L, TimeUnit.HOURS) : this.jobExecutor().awaitTermination(2L, TimeUnit.SECONDS);
        Object object = !terminated ? this.jobExecutor().shutdownNow() : BoxedUnit.UNIT;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped job executor");
        this.listenerBus().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(null);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped JobScheduler");
    }

    public void submitJobSet(JobSet jobSet) {
        if (jobSet.jobs().isEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("No jobs added for time ").append(jobSet.time()).toString());
        } else {
            this.listenerBus().post(new StreamingListenerBatchSubmitted(jobSet.toBatchInfo()));
            this.jobSets().put(jobSet.time(), jobSet);
            jobSet.jobs().foreach((Function1 & Serializable & scala.Serializable)job -> {
                JobScheduler.$anonfun$submitJobSet$2(this, job);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Added jobs for time ").append(jobSet.time()).toString());
        }
    }

    public Seq<Time> getPendingTimes() {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.jobSets()).asScala()).keys().toSeq();
    }

    public void reportError(String msg, Throwable e) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().post((Object)new ErrorReported(msg, e));
    }

    public synchronized boolean isStarted() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() != null;
    }

    public void org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(JobSchedulerEvent event) {
        block5: {
            try {
                JobSchedulerEvent jobSchedulerEvent = event;
                if (jobSchedulerEvent instanceof JobStarted) {
                    JobStarted jobStarted = (JobStarted)jobSchedulerEvent;
                    Job job = jobStarted.job();
                    long startTime = jobStarted.startTime();
                    this.handleJobStart(job, startTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof JobCompleted) {
                    JobCompleted jobCompleted = (JobCompleted)jobSchedulerEvent;
                    Job job = jobCompleted.job();
                    long completedTime = jobCompleted.completedTime();
                    this.handleJobCompletion(job, completedTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof ErrorReported) {
                    ErrorReported errorReported = (ErrorReported)jobSchedulerEvent;
                    String m = errorReported.msg();
                    Throwable e = errorReported.e();
                    this.handleError(m, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError((Object)jobSchedulerEvent);
            }
            catch (Throwable e) {
                this.reportError("Error in job scheduler", e);
            }
        }
    }

    private void handleJobStart(Job job, long startTime) {
        JobSet jobSet = this.jobSets().get(job.time());
        boolean isFirstJobOfJobSet = !jobSet.hasStarted();
        jobSet.handleJobStart(job);
        if (isFirstJobOfJobSet) {
            this.listenerBus().post(new StreamingListenerBatchStarted(jobSet.toBatchInfo()));
        }
        job.setStartTime(startTime);
        this.listenerBus().post(new StreamingListenerOutputOperationStarted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Starting job ").append(job.id()).append(" from job set of time ").append(jobSet.time()).toString());
    }

    private void handleJobCompletion(Job job, long completedTime) {
        Try<?> try_;
        JobSet jobSet = this.jobSets().get(job.time());
        jobSet.handleJobCompletion(job);
        job.setEndTime(completedTime);
        this.listenerBus().post(new StreamingListenerOutputOperationCompleted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Finished job ").append(job.id()).append(" from job set of time ").append(jobSet.time()).toString());
        if (jobSet.hasCompleted()) {
            this.listenerBus().post(new StreamingListenerBatchCompleted(jobSet.toBatchInfo()));
        }
        if ((try_ = job.result()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.reportError(new StringBuilder(18).append("Error running job ").append(job).toString(), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (jobSet.hasCompleted()) {
                this.jobSets().remove(jobSet.time());
                this.jobGenerator().onBatchCompletion(jobSet.time());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Total delay: %.3f s for time %s (execution: %.3f s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)jobSet.totalDelay() / 1000.0)), jobSet.time().toString(), BoxesRunTime.boxToDouble((double)((double)jobSet.processingDelay() / 1000.0))})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void handleError(String msg, Throwable e) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
        this.ssc().waiter().notifyError(e);
        PythonDStream$.MODULE$.stopStreamingContextIfPythonProcessIsDead(e);
    }

    public static final /* synthetic */ void $anonfun$start$3(JobScheduler $this, RateController rateController) {
        $this.ssc().addStreamingListener(rateController);
    }

    public static final /* synthetic */ void $anonfun$start$2(JobScheduler $this, InputDStream inputDStream) {
        inputDStream.rateController().foreach((Function1 & Serializable & scala.Serializable)rateController -> {
            JobScheduler.$anonfun$start$3($this, rateController);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$start$4(JobScheduler $this, StreamingListener streamingListener) {
        $this.ssc().addStreamingListener(streamingListener);
    }

    public static final /* synthetic */ void $anonfun$submitJobSet$2(JobScheduler $this, Job job) {
        $this.jobExecutor().execute(new JobHandler($this, job));
    }

    public JobScheduler(StreamingContext ssc) {
        this.ssc = ssc;
        Logging.$init$((Logging)this);
        this.jobSets = new ConcurrentHashMap<Time, JobSet>();
        this.numConcurrentJobs = ssc.conf().getInt("spark.streaming.concurrentJobs", 1);
        this.jobExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.numConcurrentJobs(), "streaming-job-executor");
        this.jobGenerator = new JobGenerator(this);
        this.clock = this.jobGenerator().clock();
        this.listenerBus = new StreamingListenerBus(ssc.sparkContext().listenerBus());
        this.receiverTracker = null;
        this.inputInfoTracker = null;
        this.executorAllocationManager = None$.MODULE$;
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = null;
    }

    public class JobHandler
    implements Runnable,
    Logging {
        private final Job job;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ JobScheduler $outer;

        public String logName() {
            return Logging.logName$((Logging)this);
        }

        public Logger log() {
            return Logging.log$((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.logInfo$((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.logDebug$((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.logTrace$((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.logWarning$((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.logError$((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
        }

        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$((Logging)this);
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        @Override
        public void run() {
            Properties oldProps = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().getLocalProperties();
            try {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperties((Properties)SerializationUtils.clone((Serializable)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().savedProperties().get()));
                String formattedTime = UIUtils$.MODULE$.formatBatchTime(this.job.time().milliseconds(), this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().graph().batchDuration().milliseconds(), false, UIUtils$.MODULE$.formatBatchTime$default$4());
                String batchUrl = new StringBuilder(21).append("/streaming/batch/?id=").append(this.job.time().milliseconds()).toString();
                String batchLinkText = new StringBuilder(32).append("[output operation ").append(this.job.outputOpId()).append(", batch time ").append(formattedTime).append("]").toString();
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setJobDescription(new StringBuilder(34).append("Streaming job from <a href=\"").append(batchUrl).append("\">").append(batchLinkText).append("</a>").toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.job.time().milliseconds())).toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToInteger((int)this.job.outputOpId())).toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS(), "true");
                EventLoop<JobSchedulerEvent> _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                if (_eventLoop != null) {
                    _eventLoop.post((Object)new JobStarted(this.job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    SparkHadoopWriterUtils$.MODULE$.disableOutputSpecValidation().withValue((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.job.run());
                    _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                    if (_eventLoop != null) {
                        _eventLoop.post((Object)new JobCompleted(this.job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    }
                }
            }
            finally {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperties(oldProps);
            }
        }

        public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer() {
            return this.$outer;
        }

        public JobHandler(JobScheduler $outer, Job job) {
            this.job = job;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.$init$((Logging)this);
        }
    }
}

