/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;

public final class ExecutorAllocationManager$
implements Logging {
    public static final ExecutorAllocationManager$ MODULE$;
    private final String ENABLED_KEY;
    private final String SCALING_INTERVAL_KEY;
    private final int SCALING_INTERVAL_DEFAULT_SECS;
    private final String SCALING_UP_RATIO_KEY;
    private final double SCALING_UP_RATIO_DEFAULT;
    private final String SCALING_DOWN_RATIO_KEY;
    private final double SCALING_DOWN_RATIO_DEFAULT;
    private final String MIN_EXECUTORS_KEY;
    private final String MAX_EXECUTORS_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExecutorAllocationManager$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public String ENABLED_KEY() {
        return this.ENABLED_KEY;
    }

    public String SCALING_INTERVAL_KEY() {
        return this.SCALING_INTERVAL_KEY;
    }

    public int SCALING_INTERVAL_DEFAULT_SECS() {
        return this.SCALING_INTERVAL_DEFAULT_SECS;
    }

    public String SCALING_UP_RATIO_KEY() {
        return this.SCALING_UP_RATIO_KEY;
    }

    public double SCALING_UP_RATIO_DEFAULT() {
        return this.SCALING_UP_RATIO_DEFAULT;
    }

    public String SCALING_DOWN_RATIO_KEY() {
        return this.SCALING_DOWN_RATIO_KEY;
    }

    public double SCALING_DOWN_RATIO_DEFAULT() {
        return this.SCALING_DOWN_RATIO_DEFAULT;
    }

    public String MIN_EXECUTORS_KEY() {
        return this.MIN_EXECUTORS_KEY;
    }

    public String MAX_EXECUTORS_KEY() {
        return this.MAX_EXECUTORS_KEY;
    }

    public boolean isDynamicAllocationEnabled(SparkConf conf) {
        int numExecutor = conf.getInt("spark.executor.instances", 0);
        boolean streamingDynamicAllocationEnabled = conf.getBoolean(this.ENABLED_KEY(), false);
        if (numExecutor != 0 && streamingDynamicAllocationEnabled) {
            throw new IllegalArgumentException("Dynamic Allocation for streaming cannot be enabled while spark.executor.instances is set.");
        }
        if (Utils$.MODULE$.isDynamicAllocationEnabled(conf) && streamingDynamicAllocationEnabled) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("\n          |Dynamic Allocation cannot be enabled for both streaming and core at the same time.\n          |Please disable core Dynamic Allocation by setting spark.dynamicAllocation.enabled to\n          |false to use Dynamic Allocation in streaming.\n        ")).stripMargin());
        }
        boolean testing = conf.getBoolean("spark.streaming.dynamicAllocation.testing", false);
        return numExecutor == 0 && streamingDynamicAllocationEnabled && (!Utils$.MODULE$.isLocalMaster(conf) || testing);
    }

    public Option<ExecutorAllocationManager> createIfEnabled(ExecutorAllocationClient client, ReceiverTracker receiverTracker, SparkConf conf, long batchDurationMs, Clock clock) {
        return this.isDynamicAllocationEnabled(conf) ? new Some((Object)new ExecutorAllocationManager(client, receiverTracker, conf, batchDurationMs, clock)) : None$.MODULE$;
    }

    private ExecutorAllocationManager$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.ENABLED_KEY = "spark.streaming.dynamicAllocation.enabled";
        this.SCALING_INTERVAL_KEY = "spark.streaming.dynamicAllocation.scalingInterval";
        this.SCALING_INTERVAL_DEFAULT_SECS = 60;
        this.SCALING_UP_RATIO_KEY = "spark.streaming.dynamicAllocation.scalingUpRatio";
        this.SCALING_UP_RATIO_DEFAULT = 0.9;
        this.SCALING_DOWN_RATIO_KEY = "spark.streaming.dynamicAllocation.scalingDownRatio";
        this.SCALING_DOWN_RATIO_DEFAULT = 0.3;
        this.MIN_EXECUTORS_KEY = "spark.streaming.dynamicAllocation.minExecutors";
        this.MAX_EXECUTORS_KEY = "spark.streaming.dynamicAllocation.maxExecutors";
    }
}

